% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allEndpoints.R
\name{get_taxa_by_ids}
\alias{get_taxa_by_ids}
\title{Retrieve taxa by their identifiers}
\usage{
get_taxa_by_ids(
  taxa,
  raw = getOption("gemma.raw", FALSE),
  memoised = getOption("gemma.memoised", FALSE),
  file = getOption("gemma.file", NA_character_),
  overwrite = getOption("gemma.overwrite", FALSE)
)
}
\arguments{
\item{taxa}{Limits the result to entities with given identifiers.
A vector of identifiers.
Identifiers can be the any of the following:
\itemize{
\item taxon ID
\item scientific name
\item common name
Retrieval by ID is more efficient.
Do not combine different identifiers in one query.
For convenience, below is a list of officially supported taxa
\tabular{rllr}{
\strong{ID} \tab \strong{Comm.name} \tab \strong{Scient.name}    \tab \strong{NcbiID}\cr
1            \tab human               \tab Homo sapiens             \tab 9606            \cr
2            \tab mouse               \tab Mus musculus             \tab 10090           \cr
3            \tab rat                 \tab Rattus norvegicus        \tab 10116           \cr
11           \tab yeast               \tab Saccharomyces cerevisiae \tab 4932            \cr
12           \tab zebrafish           \tab Danio rerio              \tab 7955            \cr
13           \tab fly                 \tab Drosophila melanogaster  \tab 7227            \cr
14           \tab worm                \tab Caenorhabditis elegans   \tab 6239
}
}}

\item{raw}{\code{TRUE} to receive results as-is from Gemma, or \code{FALSE} to enable
parsing. Raw results usually contain additional fields and flags that are
omitted in the parsed results.}

\item{memoised}{Whether or not to save to cache for future calls with the
same inputs and use the result saved in cache if a result is already saved.
Doing \code{options(gemma.memoised = TRUE)} will ensure that the cache is always
used. Use \code{\link{forget_gemma_memoised}} to clear the cache.}

\item{file}{The name of a file to save the results to, or \code{NULL} to not write
results to a file. If \code{raw == TRUE}, the output will be the raw endpoint from the
API, likely a JSON or a gzip file. Otherwise, it will be a RDS file.}

\item{overwrite}{Whether or not to overwrite if a file exists at the specified
filename.}
}
\value{
A data table with the queried taxa's details.
}
\description{
Retrieve taxa by their identifiers
}
\examples{
gemma.R:::get_taxa_by_ids(c("mouse", "human"))
}
\keyword{internal}
