% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allEndpoints.R
\name{search_gemma}
\alias{search_gemma}
\title{Search everything in Gemma}
\usage{
search_gemma(
  query,
  taxon = NA_character_,
  platform = NA_character_,
  limit = 100,
  resultType = "experiment",
  raw = getOption("gemma.raw", FALSE),
  memoised = getOption("gemma.memoised", FALSE),
  file = getOption("gemma.file", NA_character_),
  overwrite = getOption("gemma.overwrite", FALSE)
)
}
\arguments{
\item{query}{The search query. Queries can include plain text or ontology
terms They also support conjunctions ("alpha AND beta"), disjunctions ("alpha OR beta")
grouping ("(alpha OR beta) AND gamma"), prefixing ("alpha*"), wildcard characters
("BRCA?") and fuzzy matches ("alpha~").}

\item{taxon}{A numerical taxon identifier or an ncbi taxon identifier or a taxon identifier that matches either its scientific or common name}

\item{platform}{A platform numerical identifier or a platform short name}

\item{limit}{Defaults to 100 with a maximum value of 2000.
Limits the number of returned results. Note
that this function does not support pagination.}

\item{resultType}{The kind of results that should be included in the output. Can be experiment, gene, platform or a long object type name, documented in the API documentation.}

\item{raw}{\code{TRUE} to receive results as-is from Gemma, or \code{FALSE} to enable
parsing. Raw results usually contain additional fields and flags that are
omitted in the parsed results.}

\item{memoised}{Whether or not to save to cache for future calls with the
same inputs and use the result saved in cache if a result is already saved.
Doing \code{options(gemma.memoised = TRUE)} will ensure that the cache is always
used. Use \code{\link{forget_gemma_memoised}} to clear the cache.}

\item{file}{The name of a file to save the results to, or \code{NULL} to not write
results to a file. If \code{raw == TRUE}, the output will be the raw endpoint from the
API, likely a JSON or a gzip file. Otherwise, it will be a RDS file.}

\item{overwrite}{Whether or not to overwrite if a file exists at the specified
filename.}
}
\value{
If \code{raw = FALSE} and resultType is experiment, gene or platform,
a data.table containing the search results. If it is any other type, a list
of results. A list with additional details about the search if \code{raw = TRUE}
}
\description{
Search everything in Gemma
}
\examples{
search_gemma("bipolar")
}
\keyword{misc}
