% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convenience.R
\name{update_result}
\alias{update_result}
\title{Update result}
\usage{
update_result(query)
}
\arguments{
\item{query}{Output from a gemma.R function}
}
\description{
Re-runs the function used to create a gemma.R output
to update the data at hand. Useful if you have a reason
to believe parts of the data has changed since your last
accession and you wish to update while decoupling the update
process from your original code used to generate the data.
}
\details{
Note that if you have used the file and overwrite arguments
with the original call, this will also repeat to regenarete
the file based on your initial preference
}
\examples{
annots <- get_dataset_annotations(1)
# wait for a couple of years..
# wonder if the results are the same
updated_annots <- update_result(annots)

# also works with outputs of get_all_pages
platforms <- get_all_pages(get_platforms_by_ids())
updated_platforms <- update_result(platforms)

}
\keyword{misc}
