% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setcolclass.df.R
\name{setcolclass.df}
\alias{setcolclass.df}
\title{Function to set the class of columns in a data.frame}
\usage{
setcolclass.df(df, colclass, factor.levels)
}
\arguments{
\item{df}{data.frame for which columns' class need to be updated.}

\item{colclass}{class for each column of the data.frame.}

\item{factor.levels}{list of levels for each factor.}
}
\value{
A data.frame with columns' class and levels properly set
}
\description{
This function enables to set the class of each column in a data.frame.
}
\examples{
tt <- data.frame(matrix(NA, nrow=3, ncol=3, dimnames=list(1:3, paste("column", 1:3, sep="."))), 
  stringsAsFactors=FALSE)
tt <- setcolclass.df(df=tt, colclass=c("numeric", "factor", "character"), 
  factor.levels=list(NULL, c("F1", "F2", "F3"), NULL))

}
