% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readData.R
\docType{methods}
\name{readTranscriptFeatures}
\alias{readTranscriptFeatures}
\alias{readTranscriptFeatures,character-method}
\title{Function for reading exon intron and promoter structure from a given bed file}
\usage{
readTranscriptFeatures(location,remove.unusual=TRUE,
                              up.flank=1000,down.flank=1000,unique.prom=TRUE)

\S4method{readTranscriptFeatures}{character}(location, remove.unusual = TRUE,
  up.flank = 1000, down.flank = 1000, unique.prom = TRUE)
}
\arguments{
\item{location}{location of the bed file with 12 or more columns. 
The file can end in \code{.gz}, \code{.bz2}, \code{.xz}, or \code{.zip}
and/or start with \code{http://} or \code{ftp://}. If the file is not compressed
it can also start with \code{https://} or \code{ftps://}.}

\item{remove.unusual}{remove the chromomesomes with unsual names, mainly random chromsomes etc}

\item{up.flank}{up-stream from TSS to detect promoter boundaries}

\item{down.flank}{down-stream from TSS to detect promoter boundaries}

\item{unique.prom}{get only the unique promoters, promoter boundaries will not have 
a gene name if you set this option to be TRUE}
}
\value{
a \code{\link{GRangesList}} containing locations of exon/intron/promoter/TSS
}
\description{
Function for reading exon intron and promoter structure from a given bed file
}
\note{
one bed track per file is only accepted, the bed files with multiple tracks will cause en error
}
\examples{
my.bed12.file = system.file("extdata/chr21.refseq.hg19.bed", package = "genomation")
my.bed12.file
feats = readTranscriptFeatures(my.bed12.file) 
names(feats)
sapply(feats, head)
}
