% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loopBouquetPlot.R
\name{loopBouquetPlot}
\alias{loopBouquetPlot}
\title{plot GInteractions}
\usage{
loopBouquetPlot(
  gi,
  range,
  feature.gr,
  genomicSigs,
  signalTransformFun = function(x) {
     log2(x + 1)
 },
  label_region = FALSE,
  show_edges = TRUE,
  show_cluster = TRUE,
  lwd.backbone = 2,
  col.backbone = "gray",
  lwd.maxGenomicSigs = 8,
  reverseGenomicSigs = TRUE,
  col.backbone_background = "gray70",
  alpha.backbone_background = 0.5,
  lwd.gene = 2,
  lwd.nodeCircle = 1,
  col.nodeCircle = "#DDDDDD25",
  lwd.edge = 2,
  col.edge = "gray80",
  coor_mark_interval = 1e+05,
  col.coor = "black",
  show_coor = TRUE,
  coor_tick_unit = 1000,
  label_gene = TRUE,
  col.tension_line = "black",
  lwd.tension_line = 1,
  length.arrow = NULL,
  safe_text_force = 3,
  method = 1,
  doReduce = FALSE,
  ...
)
}
\arguments{
\item{gi}{An object of \link[InteractionSet:GInteractions-class]{GInteractions}}

\item{range}{The region to plot. an object of \link[GenomicRanges:GRanges-class]{GRanges}}

\item{feature.gr}{The annotation features to be added. An object of \link[GenomicRanges:GRanges-class]{GRanges}.}

\item{genomicSigs}{The genomic signals. An object of \link[GenomicRanges:GRanges-class]{GRanges} with scores or an object of \link[trackViewer:track]{track}.}

\item{signalTransformFun}{The transformation function for genomic signals.}

\item{label_region}{Label the region node or not.}

\item{show_edges}{Plot the interaction edges or not.}

\item{show_cluster}{Plot the cluster background or not.}

\item{lwd.backbone, lwd.gene, lwd.nodeCircle, lwd.edge, lwd.tension_line, lwd.maxGenomicSigs}{Line width for the
linker, gene, interaction node circle, the dashed line of interaction edges, the tension line and the maximal reversed genomic signal.}

\item{col.backbone, col.backbone_background, col.nodeCircle, col.edge, col.tension_line, col.coor}{Color
for the DNA chain, the compact DNA chain, the node circle, the linker, the tension line and the coordinates marker.}

\item{reverseGenomicSigs}{Plot the Genomic signals in reverse values.}

\item{alpha.backbone_background}{Alpha channel for transparency of backbone background.}

\item{coor_mark_interval}{The coordinates marker interval. Numeric(1). Set to 0
to turn it off. The default value 1e5 means show coordinates every 0.1M bp.}

\item{show_coor}{Show coordinates or not.}

\item{coor_tick_unit}{The bps for every ticks. Default is 1K.}

\item{label_gene}{Show gene symbol or not.}

\item{length.arrow}{Length of the edges of the arrow head (in inches).}

\item{safe_text_force}{The loops to avoid the text overlapping.}

\item{method}{Plot method. Could be 1 or 2.}

\item{doReduce}{Reduce the GInteractions or not.}

\item{...}{Parameter will be passed to \link[igraph:layout_with_fr]{layout_with_fr}.}
}
\value{
A invisible list with the key points of the plot.
}
\description{
plot graph for GInteractions
}
\examples{
library(InteractionSet)
gi <- readRDS(system.file("extdata", "gi.rds", package = "trackViewer"))
range <- GRanges("chr2", IRanges(234500000, 235000000))
library(TxDb.Hsapiens.UCSC.hg19.knownGene)
library(org.Hs.eg.db)
feature.gr <- genes(TxDb.Hsapiens.UCSC.hg19.knownGene)
feature.gr <- subsetByOverlaps(feature.gr, range(regions(gi)))
symbols <- mget(feature.gr$gene_id, org.Hs.egSYMBOL, ifnotfound = NA)
feature.gr$label[lengths(symbols) == 1] <- unlist(symbols[lengths(symbols) == 1])
feature.gr$col <- sample(1:7, length(feature.gr), replace = TRUE)
feature.gr$type <- sample(c("cRE", "gene"),
  length(feature.gr),
  replace = TRUE,
  prob = c(0.1, 0.9)
)
feature.gr$pch <- rep(NA, length(feature.gr))
feature.gr$pch[feature.gr$type == "cRE"] <- 11
loopBouquetPlot(gi, range, feature.gr)
}
