% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotDimRed.R
\name{plotDimRed}
\alias{plotDimRed}
\title{plotDimRed}
\usage{
plotDimRed(
  spe,
  plot_type = c("UMAP", "PCA"),
  annotate = NULL,
  feature_names = NULL,
  assay_name = "counts",
  update_dimnames = TRUE,
  pal = NULL,
  point_size = 0.3,
  legend_point_size = 3,
  text_by = NULL,
  text_by_size = 5,
  text_by_color = "black"
)
}
\arguments{
\item{spe}{Input data, assumed to be a \code{SpatialExperiment} or
\code{SingleCellExperiment} object.}

\item{plot_type}{Type of reduced dimension plot. Possible options are "UMAP",
"PCA", or any other set of reduced dimensions stored in the input object.
Default = "UMAP".}

\item{annotate}{Variable to show as annotations. This may be discrete or
continuous. For a discrete variable (e.g. cluster labels), this should be
the name of a column in \code{colData} containing a character vector or
factor. For a continuous variable (e.g. a gene name), this should be an
entry in \code{feature_names}. Default = NULL.}

\item{feature_names}{Name of column in \code{rowData} containing names of
continuous features to plot (e.g. gene names). For example, set to
\code{feature_names = "gene_name"} if gene names are stored in a column
named \code{"gene_name"}. This argument is used if \code{annotate} is a
continuous variable. Default = NULL, in which case the row names of the
input object will be used.}

\item{assay_name}{Name of \code{assay} in input object containing values to
plot for a continuous variable. Default = "counts".}

\item{update_dimnames}{Whether to update column names of \code{reducedDims}
to default values for plotting. Default = TRUE.}

\item{pal}{Color palette for annotations. Options for discrete values are
"libd_layer_colors", "Okabe-Ito", or any vector of color names or hex
values. For continuous values, provide a vector of length 2 for the low and
high range, e.g. c("gray90", "navy").}

\item{point_size}{Point size. Default = 0.3.}

\item{legend_point_size}{Legend point size for discrete annotations. Default
= 3.}

\item{text_by}{Column name of annotation labels to display over each cluster
of points. This will usually be the same as \code{annotate}. Alternatively,
another column may be used (e.g. with more readable classes or shorter
strings). Only used for discrete \code{annotate}. Default = NULL.}

\item{text_by_size}{Text size for annotation labels over each cluster.
Default = 5.}

\item{text_by_color}{Color name or hex code for annotation labels. Default =
"black".}
}
\value{
Returns a ggplot object, which may be further modified using ggplot
  functions.
}
\description{
Plotting functions for spatial transcriptomics data.
}
\details{
Function to create reduced dimension plot (e.g. PCA or UMAP) with additional
optional annotations such as cluster labels, expression of a gene, or quality
control metrics.
}
\examples{
library(STexampleData)
spe <- Visium_humanDLPFC()

# select spots over tissue
spe <- spe[, colData(spe)$in_tissue == 1]

# use small subset of data for this example
n <- 200
set.seed(123)
spe <- spe[, sample(seq_len(ncol(spe)), n)]

# calculate logcounts
library(scran)
spe <- logNormCounts(spe)

# identify top highly variable genes (HVGs)
is_mito <- grepl("(^MT-)|(^mt-)", rowData(spe)$gene_name)
spe <- spe[!is_mito, ]
dec <- modelGeneVar(spe)
top_hvgs <- getTopHVGs(dec, prop = 0.1)

# run dimensionality reduction
library(scater)
set.seed(123)
spe <- runPCA(spe, subset_row = top_hvgs)
set.seed(123)
spe <- runUMAP(spe, dimred = "PCA")
colnames(reducedDim(spe, "UMAP")) <- paste0("UMAP", 1:2)

# generate plot
plotDimRed(spe, plot_type = "UMAP", annotate = "ground_truth")

}
\author{
Lukas M. Weber and Yixing E. Dong
}
