% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/facet_plot.R
\name{facet_plot}
\alias{facet_plot}
\alias{geom_facet}
\title{facet_plot}
\usage{
facet_plot(p, mapping = NULL, data, geom, panel, ...)

geom_facet(mapping = NULL, data, geom, panel, ...)
}
\arguments{
\item{p}{tree view}

\item{mapping}{aes mapping for 'geom'}

\item{data}{data to plot by 'geom', first column should be matched with tip label of tree}

\item{geom}{geom function to plot the data}

\item{panel}{panel name for plot of input data}

\item{...}{additional parameters for 'geom'}
}
\value{
ggplot object
}
\description{
plot tree associated data in an additional panel
}
\details{
'facet_plot()' automatically re-arranges the input 'data' according to the tree structure,
visualizes the 'data' on specific 'panel' using the 'geom' function with aesthetic 'mapping' and other parameters,
and align the graph with the tree 'p' side by side. 'geom_facet' is a 'ggplot2' layer version of 'facet_plot'
}
\examples{
tr <- rtree(10)
dd = data.frame(id=tr$tip.label, value=abs(rnorm(10)))
p <- ggtree(tr)
facet_plot(p, 'Trait', data = dd, geom=geom_point, mapping=aes(x=value))
}
\references{
G Yu, TTY Lam, H Zhu, Y Guan (2018). Two methods for mapping and visualizing associated data
on phylogeny using ggtree. Molecular Biology and Evolution, 35(2):3041-3043.
\url{https://doi.org/10.1093/molbev/msy194}
}
\author{
Guangchuang Yu
}
