% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pkgname.R
\docType{package}
\name{globalSeq-package}
\alias{globalSeq-package}
\alias{globalSeq}
\title{Negative binomial global test}
\description{
Testing for association between RNA-Seq
and other genomic data is challenging
due to high variability of the former
and high dimensionality of the latter.

Using the negative binomial distribution and a random effects model,
we developed an omnibus test that overcomes both difficulties.
It may be conceptualised as a test of overall significance
in regression analysis, where the response variable is overdispersed
and the number of explanatory variables exceeds the sample size.

The proposed method can detect genetic and epigenetic alterations
that affect gene expression. It can examine complex regulatory
mechanisms of gene expression.
}
\section{Getting started}{


\code{\link{omnibus}} tests entire covariate sets \cr
\code{\link{proprius}} shows individual contributions \cr
\code{\link{cursus}} analyses the whole genome \cr

The following command opens the vignette: \cr
\code{utils::vignette("globalSeq")}
}

\section{More information}{


A Rauschenberger, MA Jonker, MA van de Wiel, and RX Menezes (2016).
"Testing for association between RNA-Seq and high-dimensional data",
\emph{BMC Bioinformatics}. 17:118.
\href{http://dx.doi.org/10.1186/s12859-016-0961-5}{html}
\href{http://www.biomedcentral.com/content/pdf/s12859-016-0961-5.pdf}{pdf}
(open access) \cr

\email{a.rauschenberger@vumc.nl}
}

\keyword{documentation}
