% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hclustThreshold.R
\name{hclustThreshold}
\alias{hclustThreshold}
\title{From a Sorensen-Dice threshold dissimilarity matrix, generate an object of class "hclust"}
\usage{
hclustThreshold(
  x,
  onTheFlyDev = NULL,
  method = "complete",
  jobName = paste("Equivalence cluster", method, sep = "_"),
  ylab = "Sorensen equivalence threshold dissimilarity",
  ...
)
}
\arguments{
\item{x}{an object of class "dist" with the Sorensen-Dice equivalence threshold dissimilarities matrix}

\item{onTheFlyDev}{character, name of the graphical device where to immediately display the resulting
diagram. The appropriate names depend on the operating system. Defaults to \code{NULL} and then
nothing is displayed}

\item{method}{character, one of the admissible methods in function \code{hclust}. Defaults to "complete"}

\item{jobName}{character, main plot name, defaults to
\code{paste("Equivalence cluster", onto, ontoLevel, method, sep = "_")}}

\item{ylab}{character, label of the vertical axis of the plot, defaults to "Sorensen equivalence threshold dissimilarity"}

\item{...}{additional arguments to \code{hclust}}
}
\value{
An object of class \code{equivClustSorensen}, descending from class \code{hclust}
}
\description{
From a Sorensen-Dice threshold dissimilarity matrix, generate an object of class "hclust"
}
\examples{
# Gene lists to analyse:
data("allOncoGeneLists")

# Obtaining ENTREZ identifiers for the gene universe of humans:
library(org.Hs.eg.db)
humanEntrezIDs <- keys(org.Hs.eg.db, keytype = "ENTREZID")

# First, compute the Sorensen-Dice threshold equivalence dissimilarity
# for ontology BP at level 4:
# # Very time consuming, it requires building all joint enrichment contingency tables
# dOncBP4 <- sorenThreshold(allOncoGeneLists, onto = "BP", GOLevel = 4,
#                         geneUniverse = humanEntrezIDs, orgPackg = "org.Hs.eg.db")
# Better (much faster), using the previously tabulated contingency tables:
data("cont_all_BP4")
dOncBP4 <- sorenThreshold(cont_all_BP4)
clust.threshold <- hclustThreshold(dOncBP4)
plot(clust.threshold, main = "AllOnco genelists, BP ontology at level 4",
     ylab = "Sorensen equivalence threshold")
# With the same data, an UPGMA dendrogram:
clust.threshold <- hclustThreshold(dOncBP4, method = "average")
plot(clust.threshold, main = "AllOnco genelists, BP ontology at level 4",
     ylab = "Sorensen equivalence threshold")
}
