tallyBAM = function(file, chr, start, stop, q=25, ncycles = 0, max.depth=1000000, verbose=FALSE, reference = NULL){
  region = paste(chr,":",start,"-",stop, sep="")
  a <- array(
    0,
    dim = c(18, length(file), 2, stop - start + 1),
    dimnames = list( c(paste( c("A","C","G","T"), rep( c("front","mid","back"), each=4 ), sep="." ), "-.front", "-.mid", "-.back", "+.front", "+.mid", "+.back"), file, c("+", "-"), NULL)
  )
  for( idx in seq_along(file)){
    result = .C("_tallyBAM",
                as.character(file[idx]),
                as.character(chr),
                as.integer(start),
                as.integer(stop),
                vector("integer",(stop-start+1)*18*2),
                as.integer(q),
                as.integer(2),
                as.integer(ncycles),
                as.integer(max.depth),
                as.integer(verbose),
                PACKAGE="h5vc"
    )[[5]]
    a[,idx,,] <- array(
      result,
      dim = c(18, 1, 2, stop - start + 1)
    )  
  }
  if(!is.null(reference)){
    return( prepareForHDF5( a, reference ) )
  }else{
    return( a )
  }
}