% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hdxmsqc-utils.R
\name{imTimeOutlier}
\alias{imTimeOutlier}
\title{Ion Mobility time based outlier analysis}
\usage{
imTimeOutlier(
  object,
  rightIMS = "rightIMS",
  leftIMS = "leftIMS",
  searchIMS = "Search.IMS"
)
}
\arguments{
\item{object}{An object of class \code{QFeatures}}

\item{rightIMS}{A string indicating the right boundary of the
ion mobility separation time. Defaults is "rightIMS".}

\item{leftIMS}{A string indicating the left boundary of the ion mobility
separation time. Default is "leftIMS".}

\item{searchIMS}{A string indicating the actual ion mobility search time.
The default is "Search.IMS"}
}
\description{
Ion Mobility time based outlier analysis
}
\examples{
data("BRD4df_full")
BRD4df_filtered <- isMissingAtRandom(object = BRD4df_full)
BRD4df_full_imputed <- impute(BRD4df_filtered, method = "zero", i = 1)
imTimeOutlier(object = BRD4df_full_imputed)

}
\author{
Oliver Crook
}
