% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hdxmsqc-utils.R
\name{spectraSimilarity}
\alias{spectraSimilarity}
\title{Spectral checking using data from HDsite}
\usage{
spectraSimilarity(
  peaks,
  object,
  experiment = NULL,
  mzCol = 14,
  startRT = "Start.RT",
  endRT = "End.RT",
  charge = "z",
  incorpD = "X.D.left",
  maxD = "maxD",
  numSpectra = NULL,
  ppm = 300,
  BPPARAM = bpparam()
)
}
\arguments{
\item{peaks}{a data.frame containing data exported from hdsite}

\item{object}{a data.frame obtained from HDexaminer data}

\item{experiment}{A character vector indicating the experimental conditions}

\item{mzCol}{The column in the peak information indicating the base mz value}

\item{startRT}{The column indicatng the start of the retention time. Default
is "Start.RT"}

\item{endRT}{The column indicating the end of the retention time. Default is
"End.RT}

\item{charge}{The column indicating the charge information. Default is "z".}

\item{incorpD}{The deuterium uptake value column. Default is "X.D.left".}

\item{maxD}{The maximum allowed deuterium incorporation column. Default is "maxD".}

\item{numSpectra}{The number of spectra to analyse. Default is NULL in which
all Spectra are analysed.}

\item{ppm}{The ppm error}

\item{BPPARAM}{Bioconductor parallel options.}
}
\value{
Two list of spectra observed and matching theoretical Spectra
}
\description{
Spectral checking using data from HDsite
}
\author{
Oliver Crook
}
