% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CoverageHeatmap.R
\docType{methods}
\name{CoverageHeatmap}
\alias{CoverageHeatmap}
\alias{CoverageHeatmap,GenomicRanges,GenomicRanges-method}
\alias{CoverageHeatmap,GenomicRanges,RleList-method}
\title{Generate a Heatmap of coverage}
\usage{
CoverageHeatmap(windows, track, ...)

\S4method{CoverageHeatmap}{GenomicRanges,GenomicRanges}(windows, track,
  coords = NULL, weight = 1, label = NULL, nbin = 0)

\S4method{CoverageHeatmap}{GenomicRanges,RleList}(windows, track,
  coords = NULL, label = NULL, nbin = 0)
}
\arguments{
\item{windows}{A set of GRanges of equal length}

\item{track}{A GRanges or RleList object specifying coverage}

\item{...}{additional arguments used by methods

This function generates a Heatmap object from a set of windows and an
object containing genome-wide information about coverage. Either a GRanges
or an RleList can be used. In the former case, the "weight" paramter is
passed directly to the `coverage` function. If nbin is set, binned coverage
is calculated which will save memory and time when plotting and average out
varible data.

If the coverage track contains negative values, then the scale will be
centered on zero, ie. c(-max(abs(image(hm))), max(abs(image(hm)))). This
makes more sense for most color schemes which are centered on zero, and
avoids misleading plots where either positive or negative values are
over-emphasised. See ?getScale for details. The scale can be manually reset
if desired using the "scale" method.}

\item{coords}{Co-ordinates for the heatmap, defaults to c(0, width(windows))}

\item{weight}{Passed to coverage(track) constructor if class(track) == "GRanges"}

\item{label}{Label for the heatmap}

\item{nbin}{If set, number of bins to use across each window}
}
\value{
A Heatmap object
}
\description{
Generate a Heatmap of coverage
}
\section{Methods (by class)}{
\itemize{
\item \code{windows = GenomicRanges,track = GenomicRanges}: Heatmap of Coverage from 2 GRanges

\item \code{windows = GenomicRanges,track = RleList}: Heatmap of Coverage from GRanges + RleList
}}

\examples{
data(HeatmapExamples)
CoverageHeatmap(windows, rle_list, coords=c(-100, 100), label="Example")
}
