% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PlotHeatmap.R
\docType{methods}
\name{plotHeatmap}
\alias{plotHeatmap}
\alias{plotHeatmap,Heatmap-method}
\title{Plot a Heatmap object to the device}
\usage{
plotHeatmap(heatmap, options = NULL, ...)

\S4method{plotHeatmap}{Heatmap}(heatmap, options = NULL, ...)
}
\arguments{
\item{heatmap}{A heatmap object}

\item{options}{A list containing plotting options}

\item{...}{Used for passing individual options

This function will take a heatmap and plot it to the device with
the specified options. Options can be passed together in a list
or individually as additional arguments. If passing options as a list,
it's best to first create a list containing the default settings using
heatmapOptions() andmethod  then setting options individually.

plotHeatmap() does not control device settings at all, these can be
set using plotHeatmapList() and the relevant options in heatmapOptions()

See ?heatmapOptions for a full list of options.}
}
\value{
invisible(0)
}
\description{
Plot a Heatmap object to the device
}
\section{Methods (by class)}{
\itemize{
\item \code{Heatmap}: Plot a Heatmap object to the device
}}

\examples{

data(HeatmapExamples)
plotHeatmap(hm, color="Blues")
}
\seealso{
heatmapOptions plotHeatmapList
}
