% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_metrics.R
\name{perplexityPermute}
\alias{perplexityPermute}
\title{Compute p-value for perplexity via permutation}
\usage{
perplexityPermute(spe, pm = NA, pm_cols = NA, n_perm = 1000)
}
\arguments{
\item{spe}{A SpatialExperiment object.}

\item{pm}{Optional. The probability matrix.}

\item{pm_cols}{The colnames of probability matrix. This is requires for
SpatialExperiment input. Assuming that the probability is
stored in the colData.}

\item{n_perm}{Integer number. The number of permutation. 1000 by default.}
}
\value{
A SpatialExperiment object. Calculated P-value and adjusted P-value
are saved as columns in the colData of the SpatialExperiment object.
P-value and adjusted P-value are calculated based on permutation test and
Benjamini Hochberg correction.
}
\description{
Compute p-value for perplexity via permutation
}
\examples{

data("spe_test")

spe <- readHoodData(spe, anno_col = "celltypes")

fnc <- findNearCells(spe, k = 100)

pm <- scanHoods(fnc$distance)

pm2 <- mergeByGroup(pm, fnc$cells)

spe <- mergeHoodSpe(spe, pm2)

spe <- perplexityPermute(spe, pm_cols = colnames(pm2))
}
