% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_pm.R
\docType{methods}
\name{plotHoodMat}
\alias{plotHoodMat}
\alias{plotHoodMat,matrix-method}
\alias{plotHoodMat,SpatialExperiment-method}
\title{Plot probability matrix as a heatmap}
\usage{
plotHoodMat(object, ...)

\S4method{plotHoodMat}{matrix}(
  object,
  targetCells = NA,
  n = 30,
  hm_width = 4,
  hm_height = 15,
  clusterRows = TRUE,
  clusterCols = TRUE,
  title = "Probability of neighborhoods"
)

\S4method{plotHoodMat}{SpatialExperiment}(
  object,
  pm_cols,
  targetCells = NA,
  n = 30,
  hm_width = 4,
  hm_height = 15,
  clusterRows = TRUE,
  clusterCols = TRUE,
  title = "Probability of neighborhoods"
)
}
\arguments{
\item{object}{A probability matrix or SpatialExperiment.}

\item{...}{Ignore parameter.}

\item{targetCells}{Character. Optional. Can speicify one or more cells to be plotted.}

\item{n}{Integer. The number of randomly selected cells to be plotted.
This parameter will be used when targetCells is not specify.}

\item{hm_width}{Integer. The width of heatmap.}

\item{hm_height}{Integer. The height of heatmap.}

\item{clusterRows}{Logical. Cluster rows or not.}

\item{clusterCols}{Logical. Cluster columns or not.}

\item{title}{Title of the heatmap.}

\item{pm_cols}{The colnames of probability matrix. This is requires for
SpatialExperiment input. Assuming that the probability is stored in the colData.}
}
\value{
A ComplexHeatmap plot.
}
\description{
Plot probability matrix as a heatmap
}
\examples{

data("spe_test")

spe <- readHoodData(spe, anno_col = "celltypes")

fnc <- findNearCells(spe, k = 100)

pm <- scanHoods(fnc$distance)

pm2 <- mergeByGroup(pm, fnc$cells)

spe <- mergeHoodSpe(spe, pm2)

plotHoodMat(spe, pm_cols = colnames(pm2))

}
