% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ExperimentColorMap.R
\name{ExperimentColorMap-class}
\alias{ExperimentColorMap-class}
\alias{ExperimentColorMap}
\alias{class:ExperimentColorMap}
\alias{assayColorMap}
\alias{colDataColorMap}
\alias{rowDataColorMap}
\alias{assayColorMap<-}
\alias{colDataColorMap<-}
\alias{rowDataColorMap<-}
\alias{assays,ExperimentColorMap-method}
\alias{assays<-,ExperimentColorMap,list-method}
\alias{assayNames,ExperimentColorMap-method}
\alias{assayNames<-,ExperimentColorMap,ANY-method}
\alias{colData,ExperimentColorMap-method}
\alias{colData<-,ExperimentColorMap,ANY-method}
\alias{rowData,ExperimentColorMap-method}
\alias{rowData<-,ExperimentColorMap,ANY-method}
\alias{assayColorMap,ExperimentColorMap,character-method}
\alias{assayColorMap,ExperimentColorMap,numeric-method}
\alias{assayColorMap,ExperimentColorMap,missing-method}
\alias{assay,ExperimentColorMap,character-method}
\alias{assay,ExperimentColorMap,numeric-method}
\alias{colDataColorMap,ExperimentColorMap,character-method}
\alias{colDataColorMap,ExperimentColorMap,missing-method}
\alias{rowDataColorMap,ExperimentColorMap,character-method}
\alias{rowDataColorMap,ExperimentColorMap,missing-method}
\alias{assayColorMap<-,ExperimentColorMap,character-method}
\alias{assayColorMap<-,ExperimentColorMap,numeric-method}
\alias{colDataColorMap<-,ExperimentColorMap,character-method}
\alias{rowDataColorMap<-,ExperimentColorMap,character-method}
\alias{show,ExperimentColorMap-method}
\title{ExperimentColorMap class}
\usage{
ExperimentColorMap(
  assays = list(),
  colData = list(),
  rowData = list(),
  all_discrete = list(assays = NULL, colData = NULL, rowData = NULL),
  all_continuous = list(assays = NULL, colData = NULL, rowData = NULL),
  global_discrete = NULL,
  global_continuous = NULL,
  ...
)
}
\arguments{
\item{assays}{List of colormaps for \code{assays}.}

\item{colData}{List of colormaps for \code{colData}.}

\item{rowData}{List of colormaps for \code{rowData}.}

\item{all_discrete}{Colormaps applied to all undefined
categorical \code{assays}, \code{colData}, and \code{rowData}, respectively.}

\item{all_continuous}{Colormaps applied to all undefined
continuous \code{assays}, \code{colData}, and \code{rowData}, respectively.}

\item{global_discrete}{Colormap applied to all undefined
categorical covariates.}

\item{global_continuous}{Colormap applied to all undefined
continuous covariates.}

\item{...}{additional arguments passed on to the \code{ExperimentColorMap}
constructor}
}
\value{
An object of class \code{ExperimentColorMap}
}
\description{
ExperimentColorMap class
}
\details{
Colormaps must all be functions that take at least one argument: the number
of (named) colours to return as a \code{character} vector.
This argument may be ignored in the body of the colormap function
to produce constant colormaps.
}
\section{Categorical colormaps}{


The default categorical colormap emulates the default ggplot2 categorical color palette
(Credit: \url{https://stackoverflow.com/questions/8197559/emulate-ggplot2-default-color-palette}).
This palette returns a set of colors sampled in steps of equal size that correspond to approximately equal perceptual changes in color:

\preformatted{
function(n) {
    hues=seq(15, 375, length=(n + 1))
    hcl(h=hues, l=65, c=100)[seq_len(n)]
}
}

To change the palette for all categorical variables,
users must supply a colormap that returns a similar value;
namely, an unnamed character vector of length \code{n}.
For instance, using the base R palette \code{rainbow.colors}

\preformatted{
function(n) {
    rainbow(n)
}
}
}

\section{Accessors}{


In the following code snippets, \code{x} is an \code{ExperimentColorMap} object.

\describe{
  \item{\code{assayColorMap(x, i, ..., discrete=FALSE)}:}{
  Get an \code{assays} colormap for the specified assay \code{i}.}

  \item{\code{colDataColorMap(x, i, ..., discrete=FALSE)}:}{
  Get a \code{colData} colormap for the specified \code{colData} column \code{i}.}

  \item{\code{rowDataColorMap(x, i, ..., discrete=FALSE)}:}{
  Get a \code{rowData} colormap for the specified \code{rowData} column \code{i}.}
}

If the colormap for \code{i} cannot be found, one of the default colormaps is returned.
In this case, \code{discrete} is a logical scalar that indicates whether the colormap should be categorical.
The more specialized default is first attempted -
e.g., for \code{assayColorMap}, this would be the assay colormap specified in \code{assays} of \code{all_discrete} or \code{all_continuous} -
before falling back to the global default in \code{global_discrete} or \code{global_continuous}.
Similarly, if \code{i} is missing, the default discrete/continuous colormap is returned.
}

\section{Setters}{


In the following code snippets, \code{x} is an \code{ExperimentColorMap} object,
and \code{i} is a character or numeric index.

\describe{
  \item{\code{assayColorMap(x, i, ...) <- value}:}{
  Set an \code{assays} colormap.}

  \item{\code{colDataColorMap(x, i, ...) <- value}:}{
  Set a \code{colData} colormap.}

  \item{\code{rowDataColorMap(x, i, ...) <- value}:}{
  Set a \code{rowData} colormap.}

  \item{\code{assay(x, i, ...) <- value}:}{
  Alias. Set an \code{assays} colormap.}
}
}

\examples{

# Example colormaps ----

count_colors <- function(n){
  c("black", "brown", "red", "orange", "yellow")
}
fpkm_colors <- viridis::inferno
tpm_colors <- viridis::plasma

qc_color_fun <- function(n){
  qc_colors <- c("forestgreen", "firebrick1")
  names(qc_colors) <- c("Y", "N")
  return(qc_colors)
}

# Constructor ----

ecm <- ExperimentColorMap(
    assays=list(
        counts=count_colors,
        tophat_counts=count_colors,
        cufflinks_fpkm=fpkm_colors,
        rsem_tpm=tpm_colors
    ),
    colData=list(
        passes_qc_checks_s=qc_color_fun
    )
)

# Accessors ----

# assay colormaps
assayColorMap(ecm, "logcounts") # [undefined --> default]
assayColorMap(ecm, "counts")
assayColorMap(ecm, "cufflinks_fpkm")
assay(ecm, "cufflinks_fpkm") # alias

# colData colormaps
colDataColorMap(ecm, "passes_qc_checks_s")
colDataColorMap(ecm, "undefined")

# rowData colormaps
rowDataColorMap(ecm, "undefined")

# generic accessors
assays(ecm)
assayNames(ecm)

# Setters ----

assayColorMap(ecm, "counts") <- function(n){c("blue", "white", "red")}
assay(ecm, 1) <- function(n){c("blue", "white", "red")}

colDataColorMap(ecm, "passes_qc_checks_s") <- function(n){NULL}
rowDataColorMap(ecm, "undefined") <- function(n){NULL}

# Categorical colormaps ----

# Override all discrete colormaps using the base rainbow palette
ecm <- ExperimentColorMap(global_discrete = rainbow)
n <- 10
plot(1:n, col=assayColorMap(ecm, "undefined", discrete = TRUE)(n), pch=20, cex=3)
}
