% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iSEE-options.R
\docType{data}
\name{iSEEOptions}
\alias{iSEEOptions}
\title{Global \pkg{iSEE} options}
\format{
An object of class \code{list} of length 4.
}
\usage{
iSEEOptions
}
\description{
Get or set global values that are used by relevant panels during construction and application initialization.
This has been deprecated in favor of \code{\link{panelDefaults}} (for options that apply during \linkS4class{Panel} construction)
and \code{\link{registerAppOptions}} (for options that apply during application runtime).
}
\section{Commands}{

\code{str(iSEEOptions$get())} will show the default values for all options.

\code{iSEEOptions$set(name=value)} will set the \code{name}d option to \code{value}.

\code{iSEEOptions$restore()} will reset the global options to the package default values.
}

\section{Available options}{

\describe{
\item{\code{point.color}}{Default color of data points in \code{DotPlot} panels (character).}
\item{\code{point.size}}{Default size of data points in \code{DotPlot} panels (numeric).}
\item{\code{point.alpha}}{Default alpha level controlling transparency of data points in \code{DotPlot} panels (numeric).}
\item{\code{downsample}}{Enable visual downsampling in \code{DotPlot} panels (logical).}
\item{\code{downsample.resolution}}{Resolution of the visual downsampling, if active (numeric).}
\item{\code{selected.color}}{Color of selected data points in \code{DotPlot} panels (character).}
\item{\code{selected.alpha}}{Alpha level controlling transparency of data points \emph{not} selected in \code{DotPlot} panels (numeric).}
\item{\code{selection.dynamic.single}}{Toggle dynamic single selections for all panels (logical).}
\item{\code{selection.dynamic.multiple}}{Toggle dynamic multiple selections for all panels (logical).}
\item{\code{contour.color}}{Color of the 2d density estimation contour in \code{DotPlot} panels (character).}
\item{\code{font.size}}{Global multiplier controlling the magnification of plot title and text elements in \code{DotPlot} panels (numeric).}
\item{\code{legend.position}}{Position of the legend in \code{DotPlot} and \code{ComplexHeatmapPlot} panels (one of \code{"Bottom"}, \code{"Right"}, or \code{"None"}).}
\item{\code{legend.direction}}{Position of the legend in \code{DotPlot} and \code{ComplexHeatmapPlot} panels (one of \code{"Horizontal"}, \code{"Vertical"}).}
\item{\code{panel.width}}{Default panel grid width (must be between 1 and 12).}
\item{\code{panel.height}}{Default panel height (in pixels).}
\item{\code{panel.color}}{Named character vector of colors.
The names of the vector should be set to the name of class to be overridden; if a class is not named here, its default color is used.
It is highly recommended to define colors as hex color codes (e.g., \code{"#1e90ff"}), for full compatibility with both HTML elements and R plots.}
\item{\code{color.maxlevels}}{Maximum number of levels for a categorical variable used for coloring.
Variables with more levels are coerced to numeric to avoid problems with an overly-large legend.
Defaults to 24.}
\item{\code{factor.maxlevels}}{Maximum number of levels for a categorical variable to be used anywhere in the app.
Variables with more levels are coerced to numeric to avoid rendering delays.
Defaults to 100.}
\item{\code{assay}}{Character vector of assay names to use if available, in order of preference.}
\item{\code{RowTable.select.details}}{A function that takes a string containing the name of a feature (i.e., the current selection in the \linkS4class{RowTable}) and returns a HTML element with more details.} 
\item{\code{ColumnTable.select.details}}{A function that takes a string containing the name of a sample (i.e., the current selection in the \linkS4class{ColumnTable}) and returns a HTML element with more details.}
}
}

\examples{
iSEEOptions$get('downsample'); iSEEOptions$get('selected.color')
}
\author{
Kevin Rue-Albrecht
}
\keyword{datasets}
