% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multiSelectionToFactor.R
\name{multiSelectionToFactor}
\alias{multiSelectionToFactor}
\title{Convert multiple selections into a factor}
\usage{
multiSelectionToFactor(selected, all.names)
}
\arguments{
\item{selected}{A named list of character vectors, containing the names of selected observations for different selections.
Vectors for different selections may overlap.}

\item{all.names}{Character vector of all observations.}
}
\value{
A factor containing the set(s) to which each observation is assigned.
Multiple sets are encoded as comma-separated strings.
Unselected observations are listed as \code{"unselected"}.
}
\description{
Convert multiple selection information into a factor, typically for use as a covariate or for coloring.
}
\examples{
multiSelectionToFactor(list(active=c("A", "B"), 
    saved1=c("B", "C"), saved2=c("D", "E", "F")),
    all.names=LETTERS[1:10])

}
\author{
Aaron Lun
}
