% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R
\name{observer-generics}
\alias{observer-generics}
\alias{.createObservers}
\title{Generic for the panel observers}
\description{
The workhorse generic for defining the Shiny observers for a given panel, along with recommendations on its implementation.
}
\section{Creating parameter observers}{

In \code{.createObservers(x, se, input, session, pObjects, rObjects)}, the required arguments are:
\itemize{
\item \code{x}, an instance of a \linkS4class{Panel} class.
\item \code{se}, a \linkS4class{SummarizedExperiment} object containing the current dataset.
This can be assumed to have been produced by running \code{\link{.refineParameters}(x, se)}.
\item \code{input}, the Shiny input object from the server function.
\item \code{session}, the Shiny session object from the server function.
\item \code{pObjects}, an environment containing global parameters generated in the \code{\link{iSEE}} app.
\item \code{rObjects}, a reactive list of values generated in the \code{\link{iSEE}} app.
}

Methods for this generic are expected to set up all observers required to respond to changes in the interface elements set up by \code{\link{.defineInterface}}.
Recall that each interface element has an ID of the form of \code{PANEL_SLOT}, where \code{PANEL} is the panel name (from \code{\link{.getEncodedName}}) and \code{SLOT} is the name of the slot modified by the interface element.
Thus, observers should respond to changes in those elements in \code{input}.
The return value of this generic is not used; only the side-effect of observer set-up is relevant.

It is the developer's responsibility to call \code{\link{callNextMethod}} to set up the observers required by the parent class.
This is best done by calling \code{\link{callNextMethod}} at the top of the method before defining up additional observers.
Each parent class should implement observers for its slots, so it is usually only necessary to implement observers for any newly added slots in a particular class.
}

\section{Modifying the memory}{

Consider an observer for an interface element that modifies a slot of \code{x}.
The code within this observer is expected to modify the \dQuote{memory} of the app state in \code{pObjects}, via:
\preformatted{
new_value <- input[[paste0(PANEL, "_", SLOT)]]
pObjects$memory[[PANEL]][[SLOT]] <- new_value
}

This enables \pkg{iSEE} to keep a record of the current state of the application.
In fact, any changes must go through \code{pObjects$memory} before they change the output in \code{\link{.renderOutput}};
there is no direct interaction between \code{input} and \code{output} in this framework.

We suggest using \code{\link{.createProtectedParameterObservers}} and \code{\link{.createUnprotectedParameterObservers}}, 
which create simple observers that update the memory in response to changes in the UI elements.
For handling selectize elements filled with server-side row/column names, we can use \code{\link{.createCustomDimnamesModalObservers}}.

Developers should not attempt to modify \code{x} in any observer expression.
This value does not have pass-by-reference semantics and any changes will not propagate to other parts of the application.
Rather, modifications should occur to the version of \code{x} in \code{pObjects$memory}, as described in the code chunk above.
}

\section{Triggering re-rendering}{

To trigger re-rendering of an output, observers should call \code{\link{.requestUpdate}(PANEL, rObjects)} where \code{PANEL} is the name of the current panel
This will request a re-rendering of the output with no additional side effects and is most useful for responding to aesthetic parameters.

In some cases, changes to some parameters may invalidate existing multiple selections, e.g., brushes and lassos are no longer valid if the variable on the axes are altered.
Observers responding to such changes should instead call \code{\link{.requestCleanUpdate}(PANEL, pObjects, rObjects)}, which will destroy all existing selections in order to avoid misleading conclusions.
}

\author{
Aaron Lun
}
