% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_colors.R
\name{columnSelectionColorMap}
\alias{columnSelectionColorMap}
\alias{rowSelectionColorMap}
\title{Define the selection colormap}
\usage{
columnSelectionColorMap(x, levels)

rowSelectionColorMap(x, levels)
}
\arguments{
\item{x}{An \linkS4class{ExperimentColorMap} object.}

\item{levels}{Character vector containing the available levels of a \code{ColorBy} column derived from a series of multiple selections,
usually generated by \code{\link{multiSelectionToFactor}} on the selection information in \code{row_selected} or \code{col_selected}.}
}
\value{
A named character vector of colors for each level in \code{levels}.
}
\description{
Define the colormap when coloring points in a \linkS4class{DotPlot} based on their assigned multiple row/column selection.
}
\details{
The \code{"unselected"} level is always assigned the grey color;
colors for all other levels are generated by \code{\link{colDataColorMap}(x)} or \code{\link{rowDataColorMap}(x)}.
The \code{"active"} level is always assigned the first color from these functions, regardless of whether it is present in \code{levels}.
This aims to provide some consistency in the coloring when the selections change.
}
\examples{
ecm <- ExperimentColorMap()
columnSelectionColorMap(ecm, c("active", "unselected"))
columnSelectionColorMap(ecm, c("active", "saved1", "unselected"))
columnSelectionColorMap(ecm, c("saved1", "unselected"))
columnSelectionColorMap(ecm, c("saved1"))

}
\author{
Aaron Lun
}
