% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iSEEindexResource-class.R
\docType{methods}
\name{iSEEindexResource-generics}
\alias{iSEEindexResource-generics}
\alias{precache}
\title{Generics for iSEEindexResources Objects}
\usage{
precache(x, bfc, id, ...)
}
\arguments{
\item{x}{An \code{\linkS4class{iSEEindexResource}} object.}

\item{bfc}{A \code{\link[=BiocFileCache]{BiocFileCache()}} object.}

\item{id}{A data set identifier as a character scalar.}

\item{...}{additional arguments passed to and from other methods.}
}
\value{
\code{precache()} returns the file path to the cached copy of a resource
fetched from a given URI.
}
\description{
An overview of the generics for \code{iSEEindexResources} objects.
}
\section{Preparing and caching resources}{

\code{precache(x, bfc, id, ...)} retrieves and caches a resource from an URI,
caches it, and returns the path to the cached file.
}

\examples{
library(BiocFileCache)
bfc <- BiocFileCache(cache = tempdir())

x <- iSEEindexRcallResource(list(
  uri = "rcall://system.file(package='iSEEindex','ReprocessedAllenData_config_01.R')"
))
precache(x, bfc, "ID0")
}
\author{
Kevin Rue-Albrecht
}
