% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-SummarizedExperiment.R
\name{pathwaysResultsNames}
\alias{pathwaysResultsNames}
\alias{pathwaysResults}
\title{Extract contrast results embedded in a SummarizedExperiment object}
\usage{
pathwaysResultsNames(object)

pathwaysResults(object, name)
}
\arguments{
\item{object}{A \linkS4class{SummarizedExperiment} object.}

\item{name}{(Optional) Name of a single pathway analysis result name to extract.
Use \code{pathwaysResultsNames(object)} to list available names.}
}
\value{
For \code{pathwaysResultsNames}: the names of embedded contrast results available.

For \code{pathwaysResults}: a \code{list} of differential expression statistics.

If \code{name} is missing, \code{pathwaysResults} returns a \code{list} in which each item contains the results of a single pathway analysis.
If \code{name} is given, \code{pathwaysResults} returns a \code{\linkS4class{DataFrame}} that contains the results of a single pathway analysis.
}
\description{
\code{pathwaysResults} returns either all pathway analysis results stored in \code{object}
or a single pathway analysis result by name.

\code{pathwaysResultsNames} returns the names of pathway analysis results embedded in \code{object}.
}
\examples{
library("fgsea")

##
# Simulate example data
##

simulated_data <- simulateExampleData(n_pathways = 5, n_features = 100, pathway_sizes = 15:100)

pathways_list <- simulated_data$pathwaysList
features_stats <- simulated_data$featuresStat
se <- simulated_data$summarizedexperiment

##
# Run pathway analysis ----
##

set.seed(42)
fgseaRes <- fgsea(pathways = pathways_list,
  stats    = features_stats,
  minSize  = 15,
  maxSize  = 500)
head(fgseaRes[order(pval), ])

##
# iSEEfgseaResults ----
##

se <- embedPathwaysResults(fgseaRes, se, name = "fgsea", class = "fgsea", pathwayType = "GO",
  pathwaysList = pathways_list, featuresStats = features_stats)

##
# List result names ---
##

pathwaysResultsNames(se)

##
# Extract results ---
##

pathwaysResults(se)
pathwaysResults(se, "fgsea")
}
