% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/globals.R
\name{setFeatureSetCommands}
\alias{setFeatureSetCommands}
\title{Global feature set commands}
\usage{
setFeatureSetCommands(value)
}
\arguments{
\item{value}{A list of two character vectors named \code{"collections"} and \code{"sets"}.
Both vectors should be of the same length and have the same names.
Vectors should contain R commands to create collections and retrieve sets;
see \code{?\linkS4class{FeatureSetTable}} and the output of \code{\link{createGeneSetCommands}} for details.}
}
\value{
\code{setFeatureSetCommands} will set the current global feature set commands and return \code{NULL} invisibly.
}
\description{
Set the commands to define the global collection of feature sets.
This is deprecated in favor of \code{\link{registerFeatureSetCommands}}.
}
\examples{
old <- getFeatureSetCommands()

new.cmds <- createGeneSetCommands(organism="org.Mm.eg.db",
    identifier="SYMBOL")
setFeatureSetCommands(new.cmds)

getFeatureSetCommands()

setFeatureSetCommands(old)
}
\seealso{
\code{\link{createGeneSetCommands}}, for one method of generating \code{value}.
}
\author{
Aaron Lun
}
