% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R
\docType{class}
\name{newCapSet}
\alias{newCapSet}
\alias{CapSet-class}
\alias{CapSet}
\title{Create a new CapSet object}
\usage{
newCapSet(
  expMethod,
  fastq_R1 = NULL,
  fastq_R2 = NULL,
  idxList = NULL,
  sampleNames,
  demult_R1 = NA,
  demult_R2 = NA,
  mapped_file = NA,
  filtered_file = NA,
  paired_end = TRUE
)
}
\arguments{
\item{expMethod}{experiment method ('CAGE', 'RAMPAGE' or 'MAPCap')}

\item{fastq_R1}{path for Read R1 (or file path for single end reads)}

\item{fastq_R2}{path for Read R2 (for paired end reads)}

\item{idxList}{a vector of index sequences (for demultiplexing)}

\item{sampleNames}{(required) a vector of sample names corresponding to the provided files}

\item{demult_R1}{a vector of file paths for demultiplexed R1 reads}

\item{demult_R2}{a vector of file paths for demultiplexed R2 reads}

\item{mapped_file}{a vector of file paths for mapped BAM files.}

\item{filtered_file}{a vector of file paths for de-duplicated BAM files.}

\item{paired_end}{logical, indiciting whether the data is paired end}
}
\value{
An object of class CapSet
}
\description{
The function creates an object of class `CapSet`, used for the TSS analysis.
A CapSet object can be created using the the raw, multiplxed fastq files along
with the list of sample indexes and corresponding sample names. In case the
files are already de-multiplexed or mapped, the CapSet object can also be created
using the path to demultiplexed fastq/mapped or filtered BAM files, along with
corresponding sample names. In these cases statistics and operations for the
missing files would not be possible.
}
\section{Slots}{

\describe{
\item{\code{fastqType}}{Type of fastq ('single' or 'paired')}

\item{\code{fastq_R1}}{Path to R1 fastq}

\item{\code{fastq_R2}}{Path to R1 fastq (for paired-end data)}

\item{\code{expMethod}}{Name of protocol (RAMPGE or MAPCap)}

\item{\code{sampleInfo}}{A DataFrame object created using information from
\code{\link{newCapSet}} function}

\item{\code{tss_detected}}{A GRangesList object of detected TSS}
}}

\examples{

# list of barcode IDs
idxlist <- c("CAAGTG", "TTAGCC", "GTGGAA", "TGTGAG")

dir <- system.file("extdata", package="icetea")
# corresponding sample names
fnames <- c("embryo1", "embryo2", "embryo3", "embryo4")

## CapSet object from raw (multiplexed) fastq files
cs <- newCapSet(expMethod = 'MAPCap',
       fastq_R1 = file.path(dir, 'mapcap_test_R1.fastq.gz'),
       fastq_R2 = file.path(dir, 'mapcap_test_R2.fastq.gz'),
       idxList = idxlist,
       sampleNames = fnames)

## CapSet object from mapped BAM files
bams <- list.files(file.path(dir, 'bam'), pattern = '.bam$', full.names = TRUE)
cs <- newCapSet(expMethod = 'MAPCap',
       mapped_file = bams,
       sampleNames = fnames)

}
