% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/igvShiny.R
\name{loadSegTrack}
\alias{loadSegTrack}
\alias{loadSEGTrack}
\title{load a seg track provided as a data.frame}
\usage{
loadSegTrack(session, id, trackName, tbl, deleteTracksOfSameName = TRUE)
}
\arguments{
\item{session}{an environment or list, provided and managed by shiny}

\item{id}{character string, the html element id of this widget instance}

\item{trackName}{character string}

\item{tbl}{data.frame, with at least "chrom" "start" "end" "score" columns}

\item{deleteTracksOfSameName}{logical, default TRUE}
}
\value{
nothing
}
\description{
load a SEG track provided as a data.frame.  igv "displays
segmented data as a blue-to-red heatmap where the data range is
-1.5 to 1.5... The segmented data file format is the output of
the Circular Binary Segmentation algorithm (Olshen et al., 2004)".
}
\examples{
library(igvShiny)
demo_app_file <-
  system.file(package = "igvShiny", "demos", "igvShinyDemo.R")
if (interactive()) {
  shiny::runApp(demo_app_file)
}

}
\keyword{track_loaders}
