<img src="vignettes/imcRtools_sticker.png" align="right" alt="" width="100" />

# imcRtools

<!-- badges: start -->
[![codecov](https://codecov.io/gh/BodenmillerGroup/imcRtools/branch/devel/graph/badge.svg)](https://codecov.io/gh/BodenmillerGroup/imcRtools)
[![docs](https://github.com/BodenmillerGroup/imcRtools/actions/workflows/docs.yml/badge.svg?branch=devel)](https://github.com/BodenmillerGroup/imcRtools/actions/workflows/docs.yml)
<!-- badges: end -->

This R/Bioconductor package contains helper functions to analyse IMC (or other multiplexed imaging) data.

Its official package page can be found here: [https://bioconductor.org/packages/imcRtools](https://bioconductor.org/packages/imcRtools)

**Bug notice: we discovered and fixed a bug in the `testInteractions` function in version below 1.5.5 which affected `SingleCellExperiment` or `SpatialExperiment` objects in which cells were not grouped by image. Please install the newest version of `imcRtools` directly from Github as explained below.**  

## Check status

| Bioc branch | Checks |
|:-----------:|:------:|
| Release     |[![build-check-release](https://github.com/BodenmillerGroup/imcRtools/actions/workflows/build-checks-release.yml/badge.svg?branch=devel)](https://github.com/BodenmillerGroup/imcRtools/actions/workflows/build-checks-release.yml)|
| Devel       |[![build-check-devel](https://github.com/BodenmillerGroup/imcRtools/actions/workflows/build-checks-devel.yml/badge.svg?branch=devel)](https://github.com/BodenmillerGroup/imcRtools/actions/workflows/build-checks-devel.yml)|

## Introduction

Highly multiplexed imaging techniques such as imaging mass cytometry (IMC), 
multiplexed ion beam imaging (MIBI) and cyclic immunofluorescence techniques
acquire read-outs of the expression of tens of protein in a spatially resolved
manner.

This R package supports the handling and analysis of imaging mass cytometry 
and other highly multiplexed imaging data. The main functionality includes 
reading in single-cell data after image segmentation and measurement, data 
formatting to perform channel spillover correction and a number of spatial 
analysis approaches. First, cell-cell interactions are detected via spatial 
graph construction; these graphs can be visualized with cells representing 
nodes and interactions representing edges. Furthermore, per cell, its direct 
neighbours are summarized to allow spatial clustering. Per image/grouping 
level, interactions between types of cells are counted, averaged and 
compared against random permutations. In that way, types of cells that 
interact more (attraction) or less (avoidance) frequently than expected by 
chance are detected. 

## Installation

The `imcRtools` package can be installed from `Bioconductor` via:

```r
if (!requireNamespace("BiocManager", quietly = TRUE))
    install.packages("BiocManager")

BiocManager::install("imcRtools")
```

The development version of `imcRtools` can be installed from Github via:

```r
if (!requireNamespace("remotes", quietly = TRUE))
    install.packages("remotes")

remotes::install_github("BodenmillerGroup/imcRtools")
```

## Getting help

The analysis of highly multiplexed imaging data requires multiple pre-processing
and diverse analysis steps.

1. Processing of raw data and segmentation: The 
[ImcSegmentationPipeline](https://github.com/BodenmillerGroup/ImcSegmentationPipeline) and 
the [steinbock](https://github.com/BodenmillerGroup/steinbock) 
library can be used to process and segment IMC data. The
`imcRtools` package provides reader functions for outputs generated by these 
approaches.  

2. Single-cell analysis using the [Bioconductor](https://www.bioconductor.org/) framework: The 
[Orchestrating Single-Cell Analysis with Bioconductor](https://bioconductor.org/books/release/OSCA/)
book is an excellent resource for beginners and advanced analysis concerning
single-cell data. Common analysis steps include dimensionality reduction, 
unsupervised clustering for cell type detection and data visualization.
The `imcRtools` package supports data structures that fully
integrate with the analysis presented in the OSCA book.  

3. Handling multiplexed images in R: the 
[cytomapper](https://www.bioconductor.org/packages/release/bioc/html/cytomapper.html)
Bioconductor package provides functions and data structure to handle and 
analyse highly multiplexed imaging data (images, masks and single-cell data)
natively in R.

## Citation

Please cite the following paper when using `imcRtools` in your research:

>  Windhager, J., Zanotelli, V.R.T., Schulz, D. et al. An end-to-end workflow for multiplexed image processing and analysis. Nat Protoc (2023). https://doi.org/10.1038/s41596-023-00881-0

    @article{Windhager2023,
        author = {Windhager, Jonas and Zanotelli, Vito R.T. and Schulz, Daniel and Meyer, Lasse and Daniel, Michelle and Bodenmiller, Bernd and Eling, Nils},
        title = {An end-to-end workflow for multiplexed image processing and analysis},
        year = {2023},
        doi = {10.1038/s41596-023-00881-0},
        URL = {https://www.nature.com/articles/s41596-023-00881-0},
        journal = {Nature Protocols}
    }

## Contributing

For feature requests, please open an issue [here](https://github.com/BodenmillerGroup/imcRtools/issues).

Alternatively, you can fork the repository, add your change and issue a pull request.

## Maintainer

**Daniel Schulz**
