% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mainIMGT.R
\name{getIMGT}
\alias{getIMGT}
\title{Download and Load Immune Receptor and HLA Sequences from IMGT}
\usage{
getIMGT(
  species = "human",
  gene,
  type = c("NUC", "PROT"),
  refresh = FALSE,
  suppressMessages = FALSE
)
}
\arguments{
\item{species}{The species for which to download data. Required for TCR/BCR queries.
Currently supported: "human", "mouse", "rat", "rabbit", "pig", "dog", "rhesus_monkey", "cyno monkey". Defaults to "human" for HLA.}

\item{gene}{The gene or locus to download. For TCR/BCR, this can be a specific
chain (e.g., "IGHV", "TRBJ") or a group (e.g., "IGH", "TCR"). For HLA, use "HLA".}

\item{type}{The type of sequence to retrieve. Either "NUC" for nucleotide or
"PROT" for protein sequences. This primarily distinguishes between VDJ nucleotide
and V-region amino acid sequences for TCR/BCR genes.}

\item{refresh}{Logical. If `TRUE`, forces a re-download of the data even if it
exists in the cache.}

\item{suppressMessages}{Logical. If `TRUE`, suppresses the license and other
informational messages.}
}
\value{
A `DNAStringSet` or `AAStringSet` object containing the requested sequences.
}
\description{
This is the main function to download and load reference sequences from IMGT
and the IPD-IMGT/HLA database. It handles caching of downloaded files.
}
\examples{
if(is_imgt_available()) {
  # Download human IGHV nucleotide sequences
  ighv_nuc <- getIMGT(species = "human", 
                      gene = "IGHV", 
                      type = "NUC")

  # Download all HLA protein sequences
  hla_prot <- getIMGT(gene = "HLA", 
                      type = "PROT")

  # Download all mouse TRB genes
  trb_mouse <- getIMGT(species = "mouse", 
                      gene = "TRB", 
                      type = "NUC")
}

}
