% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mainOGRDB.R
\name{getOGRDB}
\alias{getOGRDB}
\title{Download and Load Immune Receptor Germline Sequences from OGRDB (AIRR)}
\usage{
getOGRDB(
  species = "human",
  locus = c("IGH", "IGK", "IGL"),
  set_name = NULL,
  type = c("NUC", "PROT"),
  format = c("FASTA_GAPPED", "FASTA_UNGAPPED", "AIRR"),
  version = c("published", "latest"),
  species_subgroup = NULL,
  refresh = FALSE,
  suppressMessages = FALSE
)
}
\arguments{
\item{species}{Species string. Accepts "human"/"Homo sapiens"/"mouse"/"Mus 
musculus".}

\item{locus}{Either a locus short code ("IGH","IGK","IGL", etc.) OR NULL if 
you pass a `set_name` explicitly.}

\item{set_name}{Optional explicit OGRDB set name (e.g., "IGH_VDJ"). If 
provided, overrides `locus`.}

\item{type}{"NUC" (default) or "PROT". PROT will translate V-gene CDS; only 
supported for FASTA or AIRR records that include a valid CDS.}

\item{format}{"FASTA_GAPPED", "FASTA_UNGAPPED", or "AIRR". Default 
"FASTA_GAPPED".}

\item{version}{"published" (default), "latest", or a specific revision 
number as character/number.}

\item{species_subgroup}{Optional subgroup (e.g., a mouse strain like 
"C57BL/6"). If it contains '/', OGRDB requires it encoded as "\%252f".}

\item{refresh}{If TRUE, redownload even if cached.}

\item{suppressMessages}{If TRUE, be quiet.}
}
\value{
`DNAStringSet` for NUC; if `type="PROT"`, returns `AAStringSet` 
   where possible.
}
\description{
Downloads AIRR-compliant germline sets (or FASTA) from OGRDB and 
returns sequences as `DNAStringSet` (NUC) or attempts AA translation for V 
genes.
}
\examples{
if (is_ogrdb_available()) {
  # Download human IGH nucleotide sequences (gapped FASTA)
  igh_nuc <- getOGRDB(species = "human",
                      locus   = "IGH",
                      type    = "NUC",
                      format  = "FASTA_GAPPED")

  # Download human IGK sequences in AIRR JSON format
  igk_airr <- getOGRDB(species = "human",
                       locus   = "IGK",
                       type    = "NUC",
                       format  = "AIRR")

  # Download human IGL sequences and translate to AA
  igl_prot <- getOGRDB(species = "human",
                       locus   = "IGL",
                       type    = "PROT",
                       format  = "FASTA_UNGAPPED")

  # Example using an explicit set name (instead of locus)
  igh_explicit <- getOGRDB(species  = "human",
                           set_name = "IGH_VDJ",
                           type     = "NUC",
                           format   = "FASTA_GAPPED")
}

}
