% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mainOGRDB.R
\name{loadOGRDB}
\alias{loadOGRDB}
\title{Load Cached OGRDB Sequences}
\usage{
loadOGRDB(
  species = "human",
  locus = c("IGH", "IGK", "IGL"),
  set_name = NULL,
  type = c("NUC", "PROT"),
  format = c("FASTA_GAPPED", "FASTA_UNGAPPED", "AIRR"),
  version = c("published", "latest"),
  species_subgroup = NULL,
  suppressMessages = FALSE
)
}
\arguments{
\item{species}{Species string. Accepts "human"/"Homo sapiens"/"mouse"/"Mus 
musculus".}

\item{locus}{Either a locus short code ("IGH","IGK","IGL", etc.) OR NULL if 
you pass a `set_name` explicitly.}

\item{set_name}{Optional explicit OGRDB set name (e.g., "IGH_VDJ"). If 
provided, overrides `locus`.}

\item{type}{"NUC" (default) or "PROT". PROT will translate V-gene CDS; only 
supported for FASTA or AIRR records that include a valid CDS.}

\item{format}{"FASTA_GAPPED", "FASTA_UNGAPPED", or "AIRR". Default 
"FASTA_GAPPED".}

\item{version}{"published" (default), "latest", or a specific revision 
number as character/number.}

\item{species_subgroup}{Optional subgroup (e.g., a mouse strain like 
"C57BL/6"). If it contains '/', OGRDB requires it encoded as "\%252f".}

\item{suppressMessages}{If TRUE, be quiet.}
}
\value{
The same object type as \code{getOGRDB()}: a \code{DNAStringSet}
(when \code{type = "NUC"}) or an \code{AAStringSet} (when \code{type = "PROT"}),
loaded from the local cache if present (and downloaded on first use if needed).
}
\description{
Loads sequences from the local cache without attempting to download.
This function relies on `getOGRDB(refresh = FALSE)`. If the data is not found
in the cache, it will be downloaded unless an internet connection is unavailable.
}
\examples{

if (is_ogrdb_available()) {
  # First, ensure the file is cached
  getOGRDB(species = "human", locus = "IGH",
           type = "NUC", format = "FASTA_GAPPED",
           suppressMessages = TRUE)

  # Now load from cache only
  igh_cached <- loadOGRDB(species = "human",
                          locus   = "IGH",
                          type    = "NUC",
                          format  = "FASTA_GAPPED")
}
}
