% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nomenclature_queries.R
\name{get_mhcpan_input}
\alias{get_mhcpan_input}
\title{Get format for NetMHCpan tools}
\usage{
get_mhcpan_input(allele_list, mhc_class)
}
\arguments{
\item{allele_list}{list of HLA alles (e.g. c("A*01:01:01","B*27:01"))}

\item{mhc_class}{["MHC-I"|"MHC-II"] indicated which NetMHC you want to use.}
}
\value{
protein chain list as formatted for MHCpan input
}
\description{
NetMHCpan tools for MHC-peptide binding prediction require 
HLA complex names in a specific format. \code{get_mhcpan_input} formats a 
list of HLA alleles into a list of NetMHC-formated complexes.
}
\examples{
allele_list <- c("A*01:01:01","B*27:01")
get_mhcpan_input(allele_list, mhc_class = "MHC-I")
}
