% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kpAddColorRect.R
\name{kpAddColorRect}
\alias{kpAddColorRect}
\title{kpAddColorRect}
\usage{
kpAddColorRect(karyoplot, col="gray", rect.width=0.02, rect.margin=0.01,  side="left", y0=0, y1=1, r0=NULL, r1=NULL, data.panel=1, border=NA, ...)
}
\arguments{
\item{karyoplot}{a \code{karyoplot} object returned by a call to \code{plotKaryotype}}

\item{col}{(color) the color of the rectangle}

\item{rect.width}{(numeric) the width of the rectangle in plot coordinates (the whole plot has a width of 1). Usual value might be 0.05. Can be negative. (defaults to 0.02)}

\item{rect.margin}{(numeric) the additional the margin between the rectangle and the chromosome. In plot coordinates (the whole plot has a width of 1). Usual value might be 0.05. Can be negative. (defaults to 0.01)}

\item{side}{("left" or "right") The side of the plot where to plot the labels. (defaults to "left")}

\item{y0}{(numeric) If the vertical space defined by r0 and r1 goes from 0 to 1, the value at which the bottom of the rectangle starts. Ex: y0=0.5, y1=1 will create a rectangle occupying the top half of the total allocated vertical space. (defaults to 0)}

\item{y1}{(numeric) If the vertical space defined by r0 and r1 goes from 0 to 1, the value at which the top of the rectangle ends. Ex: y0=0, y1=0.5 will create a rectangle occupying the bottom half of the total allocated vertical space. (defaults to 1)}

\item{r0}{(numeric) r0 and r1 define the vertical range of the data panel to be used to position the rectangle. They can be used to split the data panel in different vertical ranges (similar to tracks in a genome browser) to plot differents data. If NULL, they are set to the min and max of the data panel, it is, to use all the available space. (defaults to NULL)}

\item{r1}{(numeric) r0 and r1 define the vertical range of the data panel to be used to position the rectangle. They can be used to split the data panel in different vertical ranges (similar to tracks in a genome browser) to plot differents data. If NULL, they are set to the min and max of the data panel, it is, to use all the available space. (defaults to NULL)}

\item{data.panel}{(numeric) The identifier of the data panel where the labels are to be added. The available data panels depend on the plot type selected in the call to \code{\link{plotKaryotype}}. (defaults to 1)}

\item{border}{(color) The color of the rectangle border. If NA, no border will be plotted. (defaults to NA)}

\item{...}{any additional parameter to be passed to the text plotting. All R base graphics params are passed along.}
}
\value{
invisibly returns the given karyoplot object
}
\description{
Add color rectangles next to the data panels. Ideal to identify the data in the plot
}
\details{
Given a KaryoPlot object, plot colored rectangles on the side of the data panels to help identify the different samples or types of data plotted
}
\examples{

 num.samples <- 10
samples.metadata <- data.frame(stage=c("I", "I", "I", "III", "IV", "III", "II", "IV", "IV", "IV"),
                                metastasis=c(0,0,0,0,1,0,0,0,1,0),
                                subtype=c("A", "A", "B", "B", "A", "B", "B", "B", "A", "B"))

kp <- plotKaryotype(plot.type=4)
for(i in 1:num.samples) {
  #metastasis
  kpAddColorRect(kp, col = colByCategory(samples.metadata$metastasis, color=c("white", "black"))[i],
                 rect.margin = 0.01, rect.width = 0.01, r0=autotrack(i, num.samples))
  #stage
  kpAddColorRect(kp, 
    col = colByCategory(samples.metadata$stage, colors=c("I"="plum1", "II"="hotpink", "III"="orange", "IV"="red2"))[i],
    rect.margin = 0.021, rect.width = 0.01, r0=autotrack(i, num.samples))
  #subtype
  kpAddColorRect(kp, 
                 col = colByCategory(samples.metadata$subtype, colors=c("dodgerblue", "gold"))[i],
                 rect.margin = 0.032, rect.width = 0.01, r0=autotrack(i, num.samples))
}

}
\seealso{
\code{\link{plotKaryotype}}, \code{\link{autotrack}}
}
