% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kpPlotHorizon.R
\name{kpPlotHorizon}
\alias{kpPlotHorizon}
\title{kpPlotHorizon}
\usage{
kpPlotHorizon(karyoplot, data=NULL, chr=NULL, x=NULL, y=NULL, 
                     num.parts=3, breaks=NULL, ymin=NULL, ymax=NULL,
                     data.panel=1, r0=0, r1=1, col="redblue6", 
                     border=NA, clipping=TRUE, ...)
}
\arguments{
\item{karyoplot}{(a \code{KaryoPlot} object) This is the first argument to all data plotting functions of \code{karyoploteR}. A KaryoPlot object referring to the currently active plot.}

\item{data}{(a \code{GRanges}) A GRanges object with the data. If \code{data} is present, \code{chr} will be set to \code{seqnames(data)} and \code{x} to the midpoints of the rages in data. If no parameter \code{y} is specified and \code{data} has a column named \code{y} or \code{value} this column will be used to define the \code{y} value of each data point. (defaults to NULL)}

\item{chr}{(a charecter vector) A vector of chromosome names specifying the chromosomes of the data points. If \code{data} is not NULL, \code{chr} is ignored. (defaults to NULL)}

\item{x}{(a numeric vector) A numeric vector with the positions (in base pairs) of the data points in the chromosomes. If \code{data} is not NULL, \code{x} is ignored. (defaults to NULL)}

\item{y}{(a numeric vector) A numeric vector with the values of the data points. If \code{y} is not NULL, it is used instead of any data column in \code{data}. (defaults to NULL)}

\item{num.parts}{(numeric) The number of parts into which the positive and the negative y spaces will be cut. Only used if \code{breaks} is NULL. (defaults to 3)}

\item{breaks}{(numeric vector or list) A numeric vector of a list with two numeric vectors named "pos" and "neg". The exact break points where the y space will be cut. If NULL, the breaks will be automatically computed using num.parts. (defaults to NULL)}

\item{ymin}{(numeric) The minimum value of \code{y} to be plotted. If NULL, it is set to the min value of the selected data panel. (defaults to NULL)}

\item{ymax}{(numeric) The maximum value of \code{y} to be plotted. If NULL, it is set to the max value of the selected data panel. (defaults to NULL)}

\item{data.panel}{(numeric) The identifier of the data panel where the data is to be plotted. The available data panels depend on the plot type selected in the call to \code{\link{plotKaryotype}}. (defaults to 1)}

\item{r0}{(numeric) r0 and r1 define the vertical range of the data panel to be used to draw this plot. They can be used to split the data panel in different vertical ranges (similar to tracks in a genome browser) to plot differents data. If NULL, they are set to the min and max of the data panel, it is, to use all the available space. (defaults to NULL)}

\item{r1}{(numeric) r0 and r1 define the vertical range of the data panel to be used to draw this plot. They can be used to split the data panel in different vertical ranges (similar to tracks in a genome browser) to plot differents data. If NULL, they are set to the min and max of the data panel, it is, to use all the available space. (defaults to NULL)}

\item{col}{(character, color vector or list) The palette name to be used, a color vector with the color to be used to define the color gradients or a list with two color vectors named "pos" and "neg". Available palettes are: redblue6, bluepurple10 and bluegold3 (defaults to "redblue6")}

\item{border}{(color) The color of the line delimiting the filled areas. If NULL the color will be assigned automatically to a darker version of the color used for the area. If NA no border will be drawn. (Defaults to NA)}

\item{clipping}{(boolean) Only used if zooming is active. If TRUE, the data representation will be not drawn out of the drawing area (i.e. in margins, etc) even if the data overflows the drawing area. If FALSE, the data representation may overflow into the margins of the plot. (defaults to TRUE)}

\item{...}{The ellipsis operator can be used to specify any additional graphical parameters. Any additional parameter will be passed to the internal calls to the R base plotting functions.}
}
\value{
Returns the original karyoplot object, unchanged.
}
\description{
Plot a horizon plot, an area-like plot where different value levels are
plotted in different colors.
}
\details{
kpPlotHorizon will create a horizon plot, a plot usually used in time series,
that will represent a wiggle value (coverage, methylation, expression...) 
that we'd usually plot with a line or area in a fraction of the vertical
space used by these function (usually in 1/6, but that's configurable).
To do that, it will cut the \code{y} space into N parts and assign a 
different color to each one, flip the negative values into the positive space
(with negative value colors) and plot all parts in the same vertical space.

A more detailed explanation of horizon plots can be found at  
https://flowingdata.com/2015/07/02/changing-price-of-food-items-and-horizon-graphs/ 
and a more detailed explanation of the horizon plots implemented in 
karyoploteR together with an explicative animation can be found at
https://bernatgel.github.io/karyoploter_tutorial/
}
\examples{


data.points <- toGRanges(data.frame(chr=c("chr1", "chr1"), start=c(1, 100), end=c(1, 100), y=c(-2, 2)))
kp <- plotKaryotype(zoom=toGRanges("chr1:1-100"))
kpLines(kp, data.points, r0=0, r1=0.5, ymin=-2, ymax=2)
kpAbline(kp, h=c(-2,-1,0,1,2), col="#AAAAAA", r0=0, r1=0.5, ymin=-2, ymax=2)
kpAxis(kp, r0=0, r1=0.5, ymin=-2, ymax=2)
kpPlotHorizon(kp, data.points, r0=0.55, r1=1)


data.points <- toGRanges(data.frame(chr="chr1", start=1:100, end=1:100))
data.points$y <- sin(start(data.points)/2)
kp <- plotKaryotype(zoom=toGRanges("chr1:1-100"))
kpLines(kp, data.points, r0=0, r1=0.5, ymin=-1, ymax=1)
kpAbline(kp, h=c(-1,0,1), col="#AAAAAA", r0=0, r1=0.5, ymin=-1, ymax=1)
kpAxis(kp, r0=0, r1=0.5, ymin=-1, ymax=1)
kpPlotHorizon(kp, data.points, r0=0.55, r1=1)


set.seed(1000)
data.points <- sort(createRandomRegions(nregions=500, mask=NA))
mcols(data.points) <- data.frame(y=runif(500, min=-3, max=3))

kp <- plotKaryotype(chromosomes=c("chr1", "chr2"))
kpPlotHorizon(kp, data=data.points)

kp <- plotKaryotype(chromosomes=c("chr1", "chr2"))
kpPlotHorizon(kp, data=data.points, num.parts=1, r0=autotrack(1, 6)$r0, r1=autotrack(1, 6)$r1)
kpPlotHorizon(kp, data=data.points, num.parts=2, r0=autotrack(2, 6)$r0, r1=autotrack(2, 6)$r1)
kpPlotHorizon(kp, data=data.points, num.parts=3, r0=autotrack(3, 6)$r0, r1=autotrack(3, 6)$r1)
kpPlotHorizon(kp, data=data.points, num.parts=5, r0=autotrack(4, 6)$r0, r1=autotrack(4, 6)$r1)
kpPlotHorizon(kp, data=data.points, num.parts=9, r0=autotrack(5, 6)$r0, r1=autotrack(5, 6)$r1)
kpPlotHorizon(kp, data=data.points, num.parts=15, r0=autotrack(6, 6)$r0, r1=autotrack(6, 6)$r1)
kpLines(kp, data=data.points, ymin=-3, ymax=3)
kpAbline(kp, h=0, ymin=-3, ymax=3)
 
kp <- plotKaryotype(chromosomes=c("chr1", "chr2"))
kpPlotHorizon(kp, data=data.points, num.parts=4, r0=autotrack(1, 6)$r0, r1=autotrack(1, 6)$r1)
kpPlotHorizon(kp, data=data.points, col="redblue6", num.parts=4, r0=autotrack(2, 6)$r0, r1=autotrack(2, 6)$r1)
kpPlotHorizon(kp, data=data.points, col="bluepurple10", num.parts=4, r0=autotrack(3, 6)$r0, r1=autotrack(3, 6)$r1)
kpPlotHorizon(kp, data=data.points, col="bluegold3", num.parts=4, r0=autotrack(4, 6)$r0, r1=autotrack(4, 6)$r1)
kpPlotHorizon(kp, data=data.points, col=c("red", "black", "green"), num.parts=4, r0=autotrack(5, 6)$r0, r1=autotrack(5, 6)$r1)
kpPlotHorizon(kp, data=data.points, col=c("red", "yellow"), num.parts=4, r0=autotrack(6, 6)$r0, r1=autotrack(6, 6)$r1)


}
\seealso{
\code{\link{plotKaryotype}}, \code{\link{kpLines}}, \code{\link{kpText}}, \code{\link{kpPlotRibbon}}
}
