% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kpPlotRibbon.R
\name{kpPlotRibbon}
\alias{kpPlotRibbon}
\title{kpPlotRibbon}
\usage{
kpPlotRibbon(karyoplot, data=NULL, chr=NULL, x0=NULL, x1=NULL, y0=NULL, y1=NULL, ymin=NULL, ymax=NULL, data.panel=1, r0=NULL, r1=NULL, col="gray80", border=NULL, clipping=TRUE, ...)
}
\arguments{
\item{karyoplot}{(a \code{KaryoPlot} object) This is the first argument to all data plotting functions of \code{karyoploteR}. A KaryoPlot object referring to the currently active plot.}

\item{data}{(a \code{GRanges}) A GRanges object with the data. If \code{data} is present, \code{chr} will be set to \code{seqnames(data)}, \code{x0} to \code{start(data)} and x1 to \code{end(data)}. If no parameter \code{y0} is specified and \code{data} has a column named \code{y0}, this column will be used. The same for \code{y1}. (defaults to NULL)}

\item{chr}{(a charecter vector) A vector of chromosome names specifying the chromosomes of the data points. If \code{data} is not NULL, \code{chr} is ignored. (defaults to NULL)}

\item{x0}{(a numeric vector) A numeric vector of x left positions (in base pairs). If \code{data} is not NULL, \code{x0}. (defaults to NULL)}

\item{x1}{(a numeric vector) A numeric vector of x right positions (in base pairs). If \code{data} is not NULL, \code{x1}. (defaults to NULL)}

\item{y0}{(a numeric vector) A numeric vector of y bottom positions. If \code{y} is not NULL, it is used instead of any data column in \code{data}. (defaults to NULL)}

\item{y1}{(a numeric vector) A numeric vector of y top positions. If \code{y} is not NULL, it is used instead of any data column in \code{data}. (defaults to NULL)}

\item{ymin}{(numeric) The minimum value of \code{y} to be plotted. If NULL, it is set to the min value of the selected data panel. (defaults to NULL)}

\item{ymax}{(numeric) The maximum value of \code{y} to be plotted. If NULL, it is set to the max value of the selected data panel. (defaults to NULL)}

\item{data.panel}{(numeric) The identifier of the data panel where the data is to be plotted. The available data panels depend on the plot type selected in the call to \code{\link{plotKaryotype}}. (defaults to 1)}

\item{r0}{(numeric) r0 and r1 define the vertical range of the data panel to be used to draw this plot. They can be used to split the data panel in different vertical ranges (similar to tracks in a genome browser) to plot differents data. If NULL, they are set to the min and max of the data panel, it is, to use all the available space. (defaults to NULL)}

\item{r1}{(numeric) r0 and r1 define the vertical range of the data panel to be used to draw this plot. They can be used to split the data panel in different vertical ranges (similar to tracks in a genome browser) to plot differents data. If NULL, they are set to the min and max of the data panel, it is, to use all the available space. (defaults to NULL)}

\item{col}{(color) The background color to plot. If NULL, it will be a lighter version of 'border' or 'black' if border is null. (Defaults to "gray80")}

\item{border}{(color) The color to use to plot the borders of the bars. If NULL, it will be a darker version of 'col'. If NA, no border will be plotted. (Defaults to NULL)}

\item{clipping}{(boolean) Only used if zooming is active. If TRUE, the data representation will be not drawn out of the drawing area (i.e. in margins, etc) even if the data overflows the drawing area. If FALSE, the data representation may overflow into the margins of the plot. (defaults to TRUE)}

\item{...}{The ellipsis operator can be used to specify any additional graphical parameters. Any additional parameter will be passed to the internal calls to the R base plotting functions.}
}
\value{
Returns the original karyoplot object, unchanged.
}
\description{
A variable width ribbon
}
\details{
\code{kpPlotRibbon} plots a variable witdh ribbon along the genome. It can be used,
for example, to plot the sd region around a line representing a mean. It can also 
be used as a replacement for \code{\link{kpBars}} creating a smoother plot without 
the the actual individual bars. \code{kpPlotRibbon} has three additional parameters
controlling the smoothing of the lines and their colors.
}
\examples{


set.seed(1000)

data <- toGRanges(data.frame(chr="chr1", start=1e6*(0:239), end=1e6*(1:240)))
y <- ((sin(start(data))/5 + rnorm(n=24, mean=0, sd=0.1))/5)+0.5
 
kp <- plotKaryotype("hg19", plot.type=2, chromosomes="chr1")

kpPlotRibbon(kp, data, y0=y-0.3, y1=y+0.3, border="red", col=lighter("red"))
kpPlotRibbon(kp, data, y0=y-0.1, y1=y+0.1, border="blue", col=lighter("blue"))
kpLines(kp, data, y=y, col="green")
kpPlotRibbon(kp, data, y0=0.5+(y-min(y)), y1=0.5-(y-min(y)), data.panel=2)

}
\seealso{
\code{\link{plotKaryotype}}, \code{\link{kpBars}}, \code{\link{kpLines}}
}
