% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/function_rainfallPlot.R
\name{rainfallPlot}
\alias{rainfallPlot}
\title{Rainfall plot.}
\usage{
rainfallPlot(
  kd,
  showSequence = "All",
  showKataegis = TRUE,
  showSegmentation = FALSE
)
}
\arguments{
\item{kd}{(\link[katdetectr]{KatDetect}): KatDetect object.}

\item{showSequence}{(character): Which sequence(s) should be visualized? Choice of: 'All', 'Kataegis', c('seqname1', 'seqname2').}

\item{showKataegis}{(logical): Highlight putative kataegis foci and underlying genomic variants?}

\item{showSegmentation}{(logical): Show changepoints and mean IMD of each segment?}
}
\value{
(\link[ggplot2]{ggplot}): Returns rainfall plot.
}
\description{
Visualize the IMD, segments and putative kataegis foci using a rainfall plot.

Y-axis represents the 5' intermutation distance (IMD) of each genomic variant in a log10-scale.
X-axis represent variant ID.

Variants within kataegis foci are bold with the kataegis foci shown in a blue rectangle (if showKataegis = TRUE). Color represent the mutation type whilst horizontal lines represent the mean IMD of a
segments and Vertical lines depict the detected changepoints (if showSegmentation = TRUE).
}
\examples{
syntheticData <- generateSyntheticData(nBackgroundVariants = 200)
kd <- detectKataegis(syntheticData)

# Visualize the IMD of the genomic variants by constructing a rainfall plot
katdetectr::rainfallPlot(kd)

# Show the chromosomes which contain one or more kataegis foci
katdetectr::rainfallPlot(kd, showSequence = "Kataegis")

# Show only chromosome 1 and 2
katdetectr::rainfallPlot(kd = kd, showSequence = c("chr1", "chr2"))

# Display changepoints and mean IMD per segment
katdetectr::rainfallPlot(kd = kd, showSequence = c("chr1", "chr2"), showSegmentation = TRUE)

}
\author{
Daan Hazelaar

Job van Riet
}
