% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/impute.R
\name{impute_na}
\alias{impute_na}
\title{Impute missing values in a LipidomicsExperiment}
\usage{
impute_na(
  data,
  measure = "Area",
  method = c("knn", "svd", "mle", "QRILC", "minDet", "minProb", "zero"),
  ...
)
}
\arguments{
\item{data}{LipidomicsExperiment object.}

\item{measure}{Which measure to use as intensity, usually Area,
Area Normalized or Height. Default is \code{Area}.}

\item{method}{The imputation method to use. All methods are wrappers for
\code{imputeLCMD} package. These include \itemize{
\item knn    Wraps \code{\link[imputeLCMD:impute.wrapper.KNN]{imputeLCMD::impute.wrapper.KNN()}}. Default. This requires an
additional argument \code{K} (Number of neighbors used to infer the missing data).
\item svd    Wraps \code{\link[imputeLCMD:impute.wrapper.SVD]{imputeLCMD::impute.wrapper.SVD()}}. This requires an
additional argument \code{K} (Number of principal components to use).
\item mle    Wraps \code{\link[imputeLCMD:impute.wrapper.MLE]{imputeLCMD::impute.wrapper.MLE()}},
\item minDet    Wraps \code{\link[imputeLCMD:impute.MinDet]{imputeLCMD::impute.MinDet()}},
\item minProb    Wraps \code{\link[imputeLCMD:impute.MinProb]{imputeLCMD::impute.MinProb()}},
\item zero    Wraps \code{\link[imputeLCMD:impute.ZERO]{imputeLCMD::impute.ZERO()}},
}}

\item{...}{Other arguments passed to the imputation method.}
}
\value{
LipidomicsExperiment object with missing values imputed.
}
\description{
Impute missing values in a LipidomicsExperiment
}
\examples{
data(data_normalized)

# Replace with values calculated using K-nearest neighbors
impute_na(data_normalized, "Area", "knn", 10)

# Replace with values calculated from the first K principal components
impute_na(data_normalized, "Area", "svd", 3)

# Replace with Maximum likelihood estimates
impute_na(data_normalized, "Area", "mle")

# Replace with randomly drawn values from a truncated distribution
impute_na(data_normalized, "Area", "QRILC")

# Replace with a minimal value
impute_na(data_normalized, "Area", "minDet")

# Replace with randomly drawn values from a Gaussian distribution
# cerntered around a minimal value
impute_na(data_normalized, "Area", "minProb")

# Replace with zero (not recommended)
impute_na(data_normalized, "Area", "zero")
}
