% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allGenerics.R, R/loci2pathResult-methods.R
\docType{methods}
\name{getMat}
\alias{getMat}
\alias{getMat,loci2pathResult-method}
\title{Extract tissue/geneset enrichment matrix from query result}
\usage{
getMat(res, ...)

\S4method{getMat}{loci2pathResult}(res, test.method = c("gene", "eqtl",
  "glm"), filter.quantile = 0.5, max.ptw.gene = 5000)
}
\arguments{
\item{res}{query result from function query.egset.list()}

\item{\dots}{additional params}

\item{test.method}{Choose which enrichment test should be used to retrive
p-values from. Options include:"gene"(default, gene-based fisher's exact 
test),"eqtl" (eqtl based fisher's exact test), "glm" (ordered query)}

\item{filter.quantile}{Filter option; choose the max quantile of all
p-values being kept in the matrix; default is 0.5, which means p-values
larger than median p-values are discarded}

\item{max.ptw.gene}{Filter option; minimum number of genes in a pathway;
default is 5000 (pathway with >5000 genes are not included in the matrix)}
}
\value{
p-value matrix collected from enrichment result table
}
\description{
This function extracts the enrichment matrix from eQTL list query result.
The rows of the matrixs are pathways; and the columns of the matrixs are
tissues/cell lines of the eQTL sets. P-Values from enrichment tests are
summarized in this matrix
}
\examples{
result <- query(query.gr=query.gr, 
  loci=eset.list, path=biocarta)
mat <- getMat(result, test.method="gene")
}
\keyword{result}
