% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allClasses.R, R/allGenerics.R, R/allAccessor.R
\docType{class}
\name{loci2pathResult-class}
\alias{loci2pathResult-class}
\alias{loci2pathResult}
\alias{resultTable}
\alias{coveredGene}
\alias{resultTable,loci2pathResult-method}
\alias{coveredGene,loci2pathResult-method}
\title{loci2pathResult Class}
\usage{
resultTable(x)

coveredGene(x)

\S4method{resultTable}{loci2pathResult}(x)

\S4method{coveredGene}{loci2pathResult}(x)
}
\arguments{
\item{x}{An geneSet object}
}
\value{
Object of CLass loci2pathResult
}
\description{
loci2pathResult Class contains information for the query result from 
query function \code{query}. Result object contains a ranked
pathway table, and a vector of gene names that are associated with loci 
covered by query regions
}
\section{Slots}{

\describe{
\item{\code{resultTable}}{data.frame; contains enrichment statistics, 
summary of eQTL and gene numbers, pathway names and gene names, etc.}

\item{\code{coveredGene}}{list; each member is a vector of genes associated 
with one tissue, whose associating loci are covered by query regions}
}}

\examples{
result <- query(query.gr=query.gr, 
  loci=eset.list, path=biocarta)
result
resultTable(result) # a data.frame for enriched pathways
coveredGene(result)  
}
