% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CtoTAssignment.R
\name{CtoTAssignment}
\alias{CtoTAssignment}
\title{CtoTAssignment for assigning the truncation read counts to the
    GRanges object with single nucleotide peaks}
\usage{
CtoTAssignment(object, bw_positive, bw_negative, sampleName = "")
}
\arguments{
\item{object}{A GRanges object which should contains all the single
nucleotide peaks of miCLIP2 experiment.}

\item{bw_positive}{A path to the bigWig file of C to T transition read
counts at the positive strand that output from the preprocess in the
m6Aboost pipeline.}

\item{bw_negative}{A path to the bigWig file of C to T transition read
counts at the negative strand that output from the preprocess in the
m6Aboost pipeline.}

\item{sampleName}{The column name that user would like to use for indicating
the name of the sample.}
}
\value{
A GRanges object with the truncation read counts.
}
\description{
An function for assigning the CtoT transition read counts from
    bigWig.
}
\examples{
if (.Platform$OS.type != "windows") {
    testpath <- system.file("extdata", package = "m6Aboost")
    test <- readRDS(file.path(testpath, "test.rds"))
    ctotBw_p <- file.path(testpath, "C2T_positive.bw")
    ctotBw_n <- file.path(testpath, "C2T_negative.bw")
    test <- CtoTAssignment(test, bw_positive=ctotBw_p, bw_negative=ctotBw_n,
        sampleName = "CtoT_WT1")
}

}
\author{
You Zhou
}
