% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cancerhotspots.R
\name{cancerhotspots}
\alias{cancerhotspots}
\title{Genotype known cancer hotspots from the tumor BAM file}
\usage{
cancerhotspots(
  bam = NULL,
  refbuild = "GRCh37",
  mapq = 10,
  sam_flag = 1024,
  vaf = 0.05,
  t_depth = 30,
  t_alt_count = 8,
  op = NULL,
  fa = NULL,
  browse = FALSE
)
}
\arguments{
\item{bam}{Input bam file. Required.}

\item{refbuild}{Default "GRCh37". Can be "GRCh37", "GRCh38", "hg19", "hg38"}

\item{mapq}{Map quality. Default 10}

\item{sam_flag}{SAM FLAG to filter reads. Default 1024}

\item{vaf}{VAF threshold. Default 0.05 [Variant filter]}

\item{t_depth}{Depth of coverage threshold. Default 30 [Variant filter]}

\item{t_alt_count}{Min. number of reads supporting tumor allele . Default 8 [Variant filter]}

\item{op}{Output file basename. Default parses from BAM file}

\item{fa}{Indexed fasta file. If provided, extracts and adds reference base to the output tsv.}

\item{browse}{If TRUE opens the html file in browser}
}
\description{
`cancerhotspots` allows rapid genotyping of known somatic variants from the tumor BAM files. This facilitates to get a quick overlook of known somatic hot-spots in a matter of minutes, without spending hours on variant calling and annotation. In simple words, it fetches nucleotide frequencies of known somatic hotspots and prioritizes them based on allele frequency.
Output includes a browsable/sharable HTML report of candidate variants.
Known cancerhotspots for both GRCh37 and GRCh38 assemblies (3180 variants) are included. This should be sufficient and cover most of the known driver genes/events. See Reference for details.
}
\references{
Chang MT, Asthana S, Gao SP, et al. Identifying recurrent mutations in cancer reveals widespread lineage diversity and mutational specificity. Nat Biotechnol. 2016;34(2):155-163. doi:10.1038/nbt.3391
}
\seealso{
\code{\link{cancerhotspotsAggr}}
}
