% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotAll_Strata.R
\name{plotAll_Strata}
\alias{plotAll_Strata}
\title{All plots of power evaulation results by strata.}
\usage{
plotAll_Strata(Power.list)
}
\arguments{
\item{Power.list}{A list produced by \code{\link{powerEval}}.}
}
\value{
It plots all power measurements of the original sequencing depth by strata in a 2x2 panel. Power measurements to plot include "FDR", "FDC", "Power", and "Precision".
}
\description{
This function plots all power measurements of the original sequencing depth by strata in a 2x2 panel. Power measurements to plot include "FDR", "FDC", "Power", and "Precision".
}
\examples{

library(magpie)
### Main function
power.test <- quickPower(dataset = "GSE55575", test_method = "TRESS")

### plot all strata results in a panel
plotAll_Strata(power.test)

}
