\name{msp}
\alias{msp}
\alias{construct.msp}
\alias{write.msp}
\alias{read.msp}
\alias{filter.msp}
\alias{xset2msp}
\alias{to.msp}
\alias{SearchNIST}
\title{Functions to handle msp-type objects (GC-MS)}
\description{
  Functions to construct, read, write and filter so-called msp
  objects, collections of spectra with additional information. This
  other information is of free format, but typically
  contains fields like \dQuote{Name}, \dQuote{CAS},
  \dQuote{ChemspiderID}, and \dQuote{rt}. 
}
\usage{
construct.msp(spectra, extra.info)
read.msp(file, only.org = FALSE,
         org.set = c("C", "H", "D", "N", "O", "P", "S"), noNumbers = NULL)
filter.msp(msp, rtrange = NULL, mzrange = NULL, minintens = 0, minPeaks = 0)
write.msp(msp, file, newFile = TRUE)
xset2msp(xsetList, settings)
to.msp(object, file = NULL, settings = NULL, ndigit = 0, 
       minfeat, minintens, intensity = c("maxo", "into"),
       secs2mins = TRUE)
SearchNIST(mspfile=NULL, savepath=NULL)
}
\arguments{
  \item{spectra}{a list of two-column or three-column numerical
    matrices. Two-column matrices only contain mz and intensity
    information, three-column matrices have a third column that gives
    retention times for the individual peaks.}
  \item{extra.info}{a nested list containing all other slots that should be
    included in the msp object. The length of this list should be equal
    to the number of spectra in the first argument.}
  \item{file}{name of input or output file containing data in msp
    format. If NULL in function \code{to.msp}, the input object is
    returned as an msp object. If non-null, the information will be
    written to the file with this name.} 
  \item{only.org}{logical: if TRUE this will skip all entries that have
    non-organical elements in the \dQuote{Formula} field.}
  \item{org.set}{List of elements to be considered as organic.}
  \item{noNumbers}{Optional argument, indicating which fields are not to
    be converted into numeric entries. If not given, this currently
    defaults to the following fields: \code{Name}, \code{CAS},
    \code{stdFile}, \code{date}, \code{validated},
    \code{ChemspiderID}, \code{SMILES}, \code{InChI},
    \code{Class}, \code{comment}, \code{csLinks}.}
  \item{msp}{msp object.}
  \item{rtrange, mzrange, minfeat, minintens, minPeaks}{restrictions to
    what constitutes genuine pseudospectra in terms of minimal numbers
    of features, minimum feature intensity, and the intensity measure
    used (peak area or peak height).}
  \item{intensity}{the measure to use for the intensity of a peak:
    either the peak height ("maxo") or area ("into").}
  \item{ndigit}{number of digits for the mz values - use 0 for nominal
    mass data.}
  \item{newFile}{logical: if TRUE starts a new file, otherwise appends.}
  \item{xsetList}{a list of xcmsSet objects.}
  \item{settings}{list containing settings.}
  \item{object}{either an object of class "xsAnnotate" or a peaktable
    containing mz, rt and I information. Function \code{to.msp} will
    convert this object into a list that can be written as an msp file.}
  \item{secs2mins}{logical: if TRUE converts retention times to minutes
    (otherwise seconds).}
  \item{mspfile}{a msp file generated by \code{to.msp} function}
  \item{savepath}{Path to the directory were NIST MSsearch program results will be saved}
}
\details{
  Even though the msp format handled by these functions is quite
  flexible, there are a couple of requirements that are not always
  satisfied by msp files generated by other software, the most important
  one being that one line may only contain one keyword. If more than one
  keyword is present, the second will likely not be read. Furthermore,
  the current implementation assumes that peaks in pseudospectra are
  represented in the form mz1, I1; mz2, I2;, etcetera - in other cases
  these are in brackets. To solve such issues, the most easy fix for the
  moment is to edit the msp file and change things globally.

  Other issues may arise with the keywords. While read.msp will be able
  to read msp files with non-standard keywords, the metaMS package
  expects at least the following list to be present (case-sensitive):
  \dQuote{Name}, \dQuote{validated}, \dQuote{CAS}, \dQuote{rt},
  \dQuote{monoMW}, and \dQuote{Class}. The final 
  keyword is always \dQuote{Num Peaks}, and should be followed by the list of
  mz-I combinations.
}
\value{
    Most of the functions here create msp files.
}
\author{Ron Wehrens}
\examples{
data("threeStdsDB")
\dontrun{
write.msp(DB, file = "huhn.msp")
DB2 <- read.msp("huhn.msp")
}
}
\keyword{manip}
