% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/methods-featdata.R
\name{featData}
\alias{featData}
\alias{featData,metabCombiner-method}
\title{Obtain Feature Metadata}
\usage{
featData(object, data = NULL)

\S4method{featData}{metabCombiner}(object, data = NULL)
}
\arguments{
\item{object}{a \code{metabCombiner} object}

\item{data}{character dataset identifier}
}
\value{
data frame of feature metadata from one or all datasets
}
\description{
This method retrieves all feature meta-data or that of one
data set. The rowIDs identically correspond to the rows from the
\code{combinedTable} data frame.
}
\details{
\code{metabCombiner} objects organized metabolomics feature
information in the "featData" slot. This table and method is primarily useful
for alignment analyses involving three or more data sets.
}
\examples{
data(plasma30)
data(plasma20)

p30 <- metabData(head(plasma30,500), samples = "CHEAR")
p20 <- metabData(head(plasma20,500), samples = "Red")

p.comb <- metabCombiner(p30, p20, xid = "p30", yid = "p20")

#full metadata extraction
fdata <- featData(p.comb, data = NULL)

#single dataset feature information extraction
fdata <- featData(p.comb, data = "p20")

}
