% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/methods-metabCombiner.R,
%   R/methods-metabData.R
\name{getStats}
\alias{getStats}
\alias{getStats,metabCombiner-method}
\alias{getStats,metabData-method}
\title{Get Object Statistics}
\usage{
getStats(object)

\S4method{getStats}{metabCombiner}(object)

\S4method{getStats}{metabData}(object)
}
\arguments{
\item{object}{metabCombiner or metabData object}
}
\value{
list of object-specific statistics
}
\description{
Prints out a list of object-specific statistics for both
\code{metabCombiner} and \code{metabData} objects
}
\section{Methods (by class)}{
\itemize{
\item \code{metabCombiner}: Method for 'metabCombiner' object
}}

\examples{
data(plasma30)
data(plasma20)
p30 <- metabData(plasma30, samples = "CHEAR")
p20 <- metabData(plasma20, samples = "Red", rtmax = 17.25)

getStats(p30) #metabData stats

p.comb <- metabCombiner(xdata = p30, ydata = p20, binGap = 0.005)
p.comb <- selectAnchors(p.comb, tolmz = 0.003, tolQ = 0.3, windy = 0.02)
p.comb <- fit_gam(p.comb, iterFilter = 1, k = 20)

getStats(p.comb) #metabCombiner stats

}
