% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bam_handler.R
\name{Bam_Handler}
\alias{Bam_Handler}
\title{A class to manage BAM files.}
\format{
A BAM manager
}
\value{
\code{Bam_Handler$new} returns a \code{Bam_Handler} object which contains
coverage related information for every BAM files.
}
\description{
This class will allow to load, convert and normalize alignments and regions
files/data.
}
\section{Constructor}{

\describe{
   \item{}{\code{bh <- Bam_Handler$new(bam_files, cores = SerialParam())}}
   \item{bam_files}{A \code{vector} of BAM filenames. The BAM files must be
                   indexed. i.e.: if a file is named file.bam, there must
                   be a file named file.bam.bai or file.bai in the same 
                   directory.}
   \item{cores}{The number of cores available to parallelize the analysis.
               Either a positive integer or a \code{BiocParallelParam}.
               Default: \code{SerialParam()}.}
   \item{paired_end}{If \code{TRUE}, metagene will deal with paired-end 
               data. If \code{FALSE}, single-end data are expected}
}

\code{Bam_Handler$new} returns a \code{Bam_Handler} object that contains
and manages BAM files. Coverage related information as alignment count can
be obtain by using this object.
}

\section{Methods}{

\describe{
   \item{}{\code{bh$get_aligned_count(bam_file)}}
   \item{bam_file}{The name of the BAM file.}
}
\describe{
   \item{}{\code{bg$get_bam_name(bam_file)}}
   \item{bam_file}{The name of the BAM file.}
}
\describe{
   \item{}{\code{bh$get_rpm_coefficient(bam_file)}}
   \item{bam_file}{The name of the BAM file.}
}
\describe{
   \item{}{\code{bh$index_bam_files(bam_files)}}
   \item{bam_files}{A \code{vector} of BAM filenames.}
}
\describe{
   \item{}{\code{bh$get_bam_files()}}
}
\describe{
   \item{}{\code{bh$get_coverage(bam_file, regions)
                               force_seqlevels = FALSE)}}
   \item{bam_file}{The name of the BAM file.}
   \item{regions}{A not empty \code{GRanges} object.}
   \item{force_seqlevels}{If \code{TRUE}, Remove regions that are not found
                   in bam file header. Default: \code{FALSE}. TRUE and FALSE
                   respectively correspond to pruning.mode = "coarse" 
                   and "error" in ?seqinfo.}
}
\describe{
   \item{}{\code{bh$get_normalized_coverage(bam_file, regions)
                               force_seqlevels = FALSE)}}
   \item{bam_file}{The name of the BAM file.}
   \item{regions}{A not empty \code{GRanges} object.}
   \item{force_seqlevels}{If \code{TRUE}, Remove regions that are not found
                   in bam file header. Default: \code{FALSE}. TRUE and FALSE
                   respectively correspond to pruning.mode = "coarse" 
                   and "error" in ?seqinfo.}
}
\describe{
   \item{chip_bam_file}{The path to the chip bam file.}
   \item{input_bam_file}{The path to the input (control) bam file.}
}
}

\examples{
bam_file <- get_demo_bam_files()[1]
bh <- metagene2:::Bam_Handler$new(bam_files = bam_file)
bh$get_aligned_count(bam_file)

}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{Bam_Handler$new()}}
\item \href{#method-get_bam_name}{\code{Bam_Handler$get_bam_name()}}
\item \href{#method-get_aligned_count}{\code{Bam_Handler$get_aligned_count()}}
\item \href{#method-get_rpm_coefficient}{\code{Bam_Handler$get_rpm_coefficient()}}
\item \href{#method-index_bam_files}{\code{Bam_Handler$index_bam_files()}}
\item \href{#method-get_bam_files}{\code{Bam_Handler$get_bam_files()}}
\item \href{#method-get_coverage}{\code{Bam_Handler$get_coverage()}}
\item \href{#method-get_normalized_coverage}{\code{Bam_Handler$get_normalized_coverage()}}
\item \href{#method-clone}{\code{Bam_Handler$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Bam_Handler$new(
  bam_files,
  cores = SerialParam(),
  paired_end = FALSE,
  strand_specific = FALSE,
  paired_end_strand_mode = 2,
  extend_reads = 0,
  invert_strand = FALSE
)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-get_bam_name"></a>}}
\if{latex}{\out{\hypertarget{method-get_bam_name}{}}}
\subsection{Method \code{get_bam_name()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Bam_Handler$get_bam_name(bam_file)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-get_aligned_count"></a>}}
\if{latex}{\out{\hypertarget{method-get_aligned_count}{}}}
\subsection{Method \code{get_aligned_count()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Bam_Handler$get_aligned_count(bam_file)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-get_rpm_coefficient"></a>}}
\if{latex}{\out{\hypertarget{method-get_rpm_coefficient}{}}}
\subsection{Method \code{get_rpm_coefficient()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Bam_Handler$get_rpm_coefficient(bam_file)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-index_bam_files"></a>}}
\if{latex}{\out{\hypertarget{method-index_bam_files}{}}}
\subsection{Method \code{index_bam_files()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Bam_Handler$index_bam_files(bam_files)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-get_bam_files"></a>}}
\if{latex}{\out{\hypertarget{method-get_bam_files}{}}}
\subsection{Method \code{get_bam_files()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Bam_Handler$get_bam_files()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-get_coverage"></a>}}
\if{latex}{\out{\hypertarget{method-get_coverage}{}}}
\subsection{Method \code{get_coverage()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Bam_Handler$get_coverage(
  bam_file,
  regions,
  force_seqlevels = FALSE,
  simplify = TRUE
)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-get_normalized_coverage"></a>}}
\if{latex}{\out{\hypertarget{method-get_normalized_coverage}{}}}
\subsection{Method \code{get_normalized_coverage()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Bam_Handler$get_normalized_coverage(
  bam_file,
  regions,
  force_seqlevels = FALSE,
  simplify = TRUE
)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Bam_Handler$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
