% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/documented_objects.R
\name{methimputeBinomialHMM}
\alias{methimputeBinomialHMM}
\title{methimputeBinomialHMM}
\value{
A list() with the following entries:
\item{convergenceInfo}{A list() with information about the convergence of the model fitting procedure.}
\item{params}{A list() with fitted and non-fitted model parameters.}
\item{params.initial}{A list() with initial values for the model parameters.}
\item{data}{A \code{\link[GenomicRanges]{GRanges-class}} with cytosine positions and methylation status calls.}
\item{segments}{The \code{data} entry where coordinates of consecutive cytosines with the same methylation status have been merged.}
}
\description{
The \code{methimputeBinomialHMM} is a list() which contains various entries (see Value section). The main entry of this object is \code{$data}, which contains the methylation status calls and posterior values. See Details for a description of all columns.
}
\details{
The \code{$data} entry in this object contains the following columns:
\itemize{
\item{context }{The sequence context of the cytosine.}
\item{counts }{Counts for methylated and total number of reads at each position.}
\item{distance }{The distance in base-pairs from the previous to the current cytosine.}
\item{transitionContext }{Transition context in the form "previous-current".}
\item{posteriorMax }{Maximum posterior value of the methylation status call, can be interpreted as the confidence in the call.}
\item{posteriorMeth }{Posterior value of the "methylated" component.}
\item{posteriorUnmeth }{Posterior value of the "unmethylated" component.}
\item{status }{Methylation status.}
\item{rc.meth.lvl }{Recalibrated methylation level, calculated as \code{r$data$rc.meth.lvl = r$data$params$emissionParams$Unmethylated[data$context,] * r$data$posteriorUnmeth + r$params$emissionParams$Methylated[data$context,] * r$data$posteriorMeth}, where \code{r} is the \code{methimputeBinomialHMM} object.}
}
}
\seealso{
\code{\link{methimpute-objects}}
}
