% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methrix_operations.R
\name{save_HDF5_methrix}
\alias{save_HDF5_methrix}
\title{Saves HDF5 methrix object}
\usage{
save_HDF5_methrix(m = NULL, dir = NULL, replace = FALSE, ...)
}
\arguments{
\item{m}{\code{\link{methrix}} object}

\item{dir}{The directory to use. Created, if not existing. Default NULL}

\item{replace}{Should it overwrite the pre-existing data? FALSE by default.}

\item{...}{Parameters to pass to saveHDF5SummarizedExperiment}
}
\value{
Nothing
}
\description{
Saves HDF5 methrix object
}
\details{
Takes \code{\link{methrix}} object and saves it
}
\examples{
data('methrix_data')
methrix_data_h5 <- convert_methrix(m=methrix_data)
target_dir = paste0(getwd(), '/temp/')
save_HDF5_methrix(methrix_data_h5, dir = target_dir, replace = TRUE)
}
