% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methylgometh.R
\name{methylgometh}
\alias{methylgometh}
\title{Adjusting number of probes in gene set testing
using gometh or gsameth in missMethyl}
\usage{
methylgometh(cpg.pval, sig.cut = 0.001, topDE = NULL,
  array.type = "450K", GS.list = NULL, GS.idtype = "SYMBOL",
  GS.type = "GO", minsize = 100, maxsize = 500)
}
\arguments{
\item{cpg.pval}{A named vector containing p-values of
differential methylation test. Names should be CpG IDs.}

\item{sig.cut}{A numeric value indicating cut-off value for significant CpG.
Default is 0.001. This argument will be ignored if topDE is provided.}

\item{topDE}{An integer. The top number of CpGs to be declared as 
significant.}

\item{array.type}{A string. Either "450K" or "EPIC". Default is "450K".}

\item{GS.list}{A list. Default is NULL. If there is no input list,
Gene Ontology is used. Entry names are gene sets names, and elements
correpond to genes that gene sets contain.}

\item{GS.idtype}{A string. "SYMBOL", "ENSEMBL", "ENTREZID" or "REFSEQ".
Default is "SYMBOL".}

\item{GS.type}{A string. "GO", "KEGG", or "Reactome"}

\item{minsize}{An integer. If the number of genes in a gene set
is less than this integer, this gene set is not tested. Default is 100.}

\item{maxsize}{An integer. If the number of genes in a gene set
is greater than this integer, this gene set is not tested. Default is 500.}
}
\value{
A data frame contains gene set tests results.
}
\description{
This function calls gometh or gsameth function
in missMethyl package to adjust number of probes in gene set testing
}
\examples{
\dontrun{
library(IlluminaHumanMethylation450kanno.ilmn12.hg19)
data(cpgtoy)
res = methylgometh(cpg.pval = cpg.pval, sig.cut = 0.001, GS.type = "KEGG",
minsize = 200, maxsize = 205)
head(res)
}
}
\references{
Phipson, B., Maksimovic, J., and Oshlack, A. (2015).
missMethyl: an R package for analysing methylation data from Illuminas
HumanMethylation450 platform. Bioinformatics, btv560.

Ligtenberg W (2017). reactome.db: A set of annotation maps
for reactome. R package version 1.62.0.

Carlson M (2017). org.Hs.eg.db: Genome wide annotation
for Human. R package version 3.5.0.
}
