% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methylInheritance.R
\docType{data}
\name{methylInheritanceResults}
\alias{methylInheritanceResults}
\title{All observed and permutation results formatted in a
\code{methylInheritanceResults} class (for demo purpose).}
\format{
a \code{list} of class \code{methylInheritanceAllResults}
containing the following elements:
\itemize{
\item \code{OBSERVATION} a \code{list} containing:
\itemize{
\item \code{SITES} a \code{list} containing:
\itemize{
\item\code{i2} a \code{list} containing:
\itemize{
\item \code{HYPER} a \code{list} of \code{integer} with 2 entries,
the number of conserved
hyper differentially methylated sites between two consecutive generations.
The first element represents the intersection of the first and second
generations; the second element, the intersection of the second and third
generations.
\item \code{HYPO} a \code{list} of \code{integer} with 2 entries,
the number of conserved
hypo differentially methylated sites between two consecutive generations.
The first element represents the intersection of the first and second
generations; the second element, the intersection of the second and third
generations.
}
\item\code{iAll} a \code{list} containing:
\itemize{
\item \code{HYPER} a \code{list} of \code{integer} with 1 entry,
the number of conserved
hyper differentially methylated sites between the three consecutive
generations.
\item \code{HYPO} a \code{list} of \code{integer} with 1 entry, the number
of conserved hypo differentially methylated sites between the three
consecutive generations.
}
}
\item \code{TILES} a \code{list} containing:
\itemize{
\item\code{i2} a \code{list} containing:
\itemize{
\item \code{HYPER} a \code{list} of \code{integer} with 2 entries,
the number of conserved
hyper differentially methylated positions between two consecutive
generations. The first element represents the intersection of the
first and second generations; the second element, the intersection of
the second and third generations.
\item \code{HYPO} a \code{list} of \code{integer} with 2 entries,
the number of conserved
hypo differentially methylated positions between two consecutive
generations.The first element represents the intersection of the first and
second generations; the second element, the intersection of the second
and third generations.
}
\item\code{iAll} a \code{list} containing:
\itemize{
\item \code{HYPER} a \code{list} of \code{integer} with 1 entry,
the number of conserved
hyper differentially methylated positions between the three consecutive
generations.
\item \code{HYPO} a \code{list} of \code{integer} with 1 entry,
the number of conserved
hypo differentially methylated positions between the three consecutive
generations.
}
}
}
\item \code{PERMUTATION} a \code{list}
containing \code{nbrPermutations} entries. Each entry is
a \code{list} containing:
\itemize{
\item \code{SITES} a \code{list} containing:
\itemize{
\item\code{i2} a \code{list} containing:
\itemize{
\item \code{HYPER} a \code{list} of \code{integer} with 2 entries,
the number of conserved
hyper differentially methylated sites between two consecutive generations.
The first element represents the intersection of the first and second
generations; the second element, the intersection of the second and third
generations.
\item \code{HYPO} a \code{list} of \code{integer} with 2 entries,
the number of conserved
hypo differentially methylated sites between two consecutive generations.The
first element represents the intersection of the first and second
generations; the second element, the intersection of the second and third
generations.
}
\item\code{iAll} a \code{list} containing:
\itemize{
\item \code{HYPER} a \code{list} of \code{integer} with 1 entry,
the number of conserved
hyper differentially methylated sites between the three consecutive
generations.
\item \code{HYPO} a \code{list} of \code{integer} with 1 entry,
the number of conserved
hypo differentially methylated sites between the three consecutive
generations.
}
}
\item \code{TILES} a \code{list} containing:
\itemize{
\item\code{i2} a \code{list} containing:
\itemize{
\item \code{HYPER} a \code{list} of \code{integer} with 2 entries,
the number of conserved
hyper differentially methylated positions between two consecutive
generations. The first element represents the intersection of the
first and second generations; the second element, the intersection of
the second and third generations.
\item \code{HYPO} a \code{list} of \code{integer} with 2 entries,
the number of conserved
hypo differentially methylated positions between two consecutive
generations.The first element represents the intersection of the first and
second generations; the second element, the intersection of the second
and third generations.
}
\item\code{iAll} a \code{list} containing:
\itemize{
\item \code{HYPER} a \code{list} of \code{integer} with 1 entry,
the number of conserved
hyper differentially methylated positions between the three consecutive
generations.
\item \code{HYPO} a \code{list} of \code{integer} with 1 entry,
the number of conserved
hypo differentially methylated positions between the three consecutive
generations.
}
}
}
}
}
\usage{
data(methylInheritanceResults)
}
\value{
a \code{list} of class \code{methylInheritanceAllResults}
containing the following elements:
\itemize{
\item \code{OBSERVATION} a \code{list} containing:
\itemize{
\item \code{SITES} a \code{list} containing:
\itemize{
\item\code{i2} a \code{list} containing:
\itemize{
\item \code{HYPER} a \code{list} of \code{integer} with 2 entries,
the number of conserved
hyper differentially methylated sites between two consecutive generations.
The first element represents the intersection of the first and second
generations; the second element, the intersection of the second and third
generations.
\item \code{HYPO} a \code{list} of \code{integer} with 2 entries,
the number of conserved
hypo differentially methylated sites between two consecutive generations.
The first element represents the intersection of the first and second
generations; the second element, the intersection of the second and third
generations.
}
\item \code{iAll} a \code{list} containing:
\itemize{
\item \code{HYPER} a \code{list} of \code{integer} with 1 entry,
the number of conserved
hyper differentially methylated sites between the three consecutive
generations.
\item \code{HYPO} a \code{list} of \code{integer} with 1 entry, the number
of conserved hypo differentially methylated sites between the three
consecutive generations.
}
}
\item \code{TILES} a \code{list} containing:
\itemize{
\item \code{i2} a \code{list} containing:
\itemize{
\item \code{HYPER} a \code{list} of \code{integer} with 2 entries,
the number of conserved
hyper differentially methylated positions between two consecutive
generations. The first element represents the intersection of the
first and second generations; the second element, the intersection of
the second and third generations.
\item \code{HYPO} a \code{list} of \code{integer} with 2 entries,
the number of conserved
hypo differentially methylated positions between two consecutive
generations.The first element represents the intersection of the first and
second generations; the second element, the intersection of the second
and third generations.
}
\item\code{iAll} a \code{list} containing:
\itemize{
\item \code{HYPER} a \code{list} of \code{integer} with 1 entry,
the number of conserved
hyper differentially methylated positions between the three consecutive
generations.
\item \code{HYPO} a \code{list} of \code{integer} with 1 entry,
the number of conserved
hypo differentially methylated positions between the three consecutive
generations.
}
}
}
\item \code{PERMUTATION} a \code{list}
containing a number of entries corresponding to the number of permutations
that have been produced. Each entry is
a \code{list} containing:
\itemize{
\item \code{SITES} a \code{list} containing:
\itemize{
\item\code{i2} a \code{list} containing:
\itemize{
\item \code{HYPER} a \code{list} of \code{integer} with 2 entries,
the number of conserved
hyper differentially methylated sites between two consecutive generations.
The first element represents the intersection of the first and second
generations; the second element, the intersection of the second and third
generations.
\item \code{HYPO} a \code{list} of \code{integer} with 2 entries,
the number of conserved
hypo differentially methylated sites between two consecutive generations.The
first element represents the intersection of the first and second
generations; the second element, the intersection of the second and third
generations.
}
\item\code{iAll} a \code{list} containing:
\itemize{
\item \code{HYPER} a \code{list} of \code{integer} with 1 entry,
the number of conserved
hyper differentially methylated sites between the three consecutive
generations.
\item \code{HYPO} a \code{list} of \code{integer} with 1 entry,
the number of conserved
hypo differentially methylated sites between the three consecutive
generations.
}
}
\item \code{TILES} a \code{list} containing:
\itemize{
\item\code{i2} a \code{list} containing:
\itemize{
\item \code{HYPER} a \code{list} of \code{integer} with 2 entries,
the number of conserved
hyper differentially methylated positions between two consecutive
generations. The first element represents the intersection of the
first and second generations; the second element, the intersection of
the second and third generations.
\item \code{HYPO} a \code{list} of \code{integer} with 2 entries,
the number of conserved
hypo differentially methylated positions between two consecutive
generations.The first element represents the intersection of the first and
second generations; the second element, the intersection of the second
and third generations.
}
\item\code{iAll} a \code{list} containing:
\itemize{
\item \code{HYPER} a \code{list} of \code{integer} with 1 entry,
the number of conserved
hyper differentially methylated positions between the three consecutive
generations.
\item \code{HYPO} a \code{list} of \code{integer} with 1 entry,
the number of conserved
hypo differentially methylated positions between the three consecutive
generations.
}
}
}
}
}
\description{
The object is a \code{list} with 2 entries: "OBSERVATION" and
"PERMUTATION".
}
\details{
This dataset can be
used to test the \code{extractInfo} function.The extracted information can
be used to calculate the significant level or to create a graph.
}
\examples{

## Loading dataset containing all results
data(methylInheritanceResults)

## Extract information for the intersection between conserved differentially
## methylated sites (type = sites) between the intersection of 2
## generations (inter = i2): F1 and F2 (position = 1)
extractInfo(allResults = methylInheritanceResults,
    type = "sites", inter="i2", 1)

}
\seealso{
\describe{
    \item{\code{\link{extractInfo}}}{ for extracting the
    information specific to a subsection of the permutation analysis}
}
}
\keyword{datasets}
